/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import owmii.powah.block.cable.CableTile;

class CableNet {
    private static final Map<Level, Map<BlockPos, CableTile>> loadedCables = new WeakHashMap<Level, Map<BlockPos, CableTile>>();
    List<CableTile> cableList;

    static void addCable(CableTile cable) {
        CableTile previousCable = loadedCables.computeIfAbsent(cable.m_58904_(), l -> new HashMap()).put(cable.m_58899_().m_7949_(), cable);
        if (previousCable != null) {
            throw new RuntimeException("Cable added to position %s, but there was already one there?".formatted(cable.m_58899_()));
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void removeCable(CableTile cable) {
        Map<BlockPos, CableTile> levelMap = loadedCables.get(cable.m_58904_());
        if (levelMap.remove(cable.m_58899_()) != cable) {
            throw new RuntimeException("Removed wrong cable from position %s".formatted(cable.m_58899_()));
        }
        if (levelMap.size() == 0) {
            loadedCables.remove(cable.m_58904_());
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void updateAdjacentCables(CableTile cable) {
        Map<BlockPos, CableTile> levelMap = loadedCables.get(cable.m_58904_());
        if (levelMap == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = cable.m_58899_().m_121945_(direction);
            CableTile adjCable = levelMap.get(adjPos);
            if (adjCable == null || adjCable.net == null) continue;
            adjCable.net.cableList.forEach(c -> {
                c.net = null;
            });
        }
    }

    static void calculateNetwork(CableTile cable) {
        Map<BlockPos, CableTile> levelMap = Objects.requireNonNull(loadedCables.get(cable.m_58904_()), "No level map?");
        LinkedHashSet<CableTile> cables = new LinkedHashSet<CableTile>();
        ArrayDeque<CableTile> queue = new ArrayDeque<CableTile>();
        cables.add(cable);
        queue.add(cable);
        while (!queue.isEmpty()) {
            CableTile cur = (CableTile)queue.pop();
            for (Direction direction : Direction.values()) {
                BlockPos adjPos = cur.m_58899_().m_121945_(direction);
                CableTile adjCable = levelMap.get(adjPos);
                if (adjCable == null || !cables.add(adjCable)) continue;
                queue.add(adjCable);
            }
        }
        CableNet net = new CableNet(new ArrayList<CableTile>(cables));
        for (CableTile tile : net.cableList) {
            tile.net = net;
        }
    }

    CableNet(List<CableTile> cableList) {
        this.cableList = cableList;
    }
}

