/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.inventory.RecipeWrapper;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.recipe.Recipes;

public class EnergizingOrbTile
extends AbstractTickableTile<IVariant.Single, EnergizingOrbBlock>
implements IInventoryHolder {
    private final Energy buffer = Energy.create(0L);
    private boolean containRecipe;
    @Nullable
    private EnergizingRecipe recipe;

    public EnergizingOrbTile(BlockPos pos, BlockState state) {
        super(Tiles.ENERGIZING_ORB.get(), pos, state);
        this.inv.set(7);
    }

    @Override
    public void readSync(CompoundTag nbt) {
        super.readSync(nbt);
        this.buffer.read(nbt, "buffer", true, false);
        this.buffer.setTransfer(this.buffer.getCapacity());
        this.containRecipe = nbt.m_128471_("contain_recipe");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt) {
        this.buffer.write(nbt, "buffer", true, false);
        nbt.m_128379_("contain_recipe", this.containRecipe);
        return super.writeSync(nbt);
    }

    public Direction getOrbUp() {
        BlockState state;
        if (this.f_58857_ != null && (state = this.m_58900_()).m_61138_((Property)BlockStateProperties.f_61372_)) {
            return ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        }
        return Direction.UP;
    }

    public Vec3 getOrbCenter() {
        Direction up = this.getOrbUp();
        double scale = 0.1;
        return Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_((double)up.m_122429_() * scale, (double)up.m_122430_() * scale, (double)up.m_122431_() * scale);
    }

    @Nullable
    public EnergizingRecipe currRecipe() {
        return this.recipe;
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        this.checkRecipe();
    }

    @Override
    public void onSlotChanged(int index) {
        if (!this.isRemote()) {
            this.buffer.setCapacity(0L);
            this.buffer.setStored(0L);
            this.buffer.setTransfer(0L);
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.f_58857_ != null && !this.isRemote()) {
            Optional recipe = this.f_58857_.m_7465_().m_44015_(Recipes.ENERGIZING.get(), (Container)new RecipeWrapper(this.getInventory()), this.f_58857_);
            if (recipe.isPresent()) {
                this.recipe = (EnergizingRecipe)recipe.get();
                this.buffer.setCapacity(this.recipe.getEnergy());
                this.buffer.setTransfer(this.recipe.getEnergy());
            } else {
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
            }
            this.setContainRecipe(recipe.isPresent());
            this.sync(1);
        }
    }

    public long fillEnergy(long amount) {
        long filled = Math.min(this.buffer.getEmpty(), amount);
        if (this.f_58857_ != null && this.recipe != null) {
            this.buffer.produce(filled);
            if (this.buffer.isFull()) {
                ItemStack stack = this.recipe.m_8043_();
                this.inv.clear();
                this.inv.setStackInSlot(0, stack.m_41777_());
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
                this.m_6596_();
            }
            this.sync(5);
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public Energy getBuffer() {
        return this.buffer;
    }

    @Override
    public int getSlotLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return slot == 0;
    }

    @Override
    public boolean canInsert(int index, ItemStack stack) {
        return index != 0 && this.inv.getStackInSlot(0).m_41619_() && this.inv.getStackInSlot(index).m_41619_();
    }
}

