/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.util.Util;
import owmii.powah.lib.util.math.V3d;

public class EnergizingRodBlock
extends AbstractEnergyBlock<EnergyConfig, EnergizingRodBlock>
implements SimpleWaterloggedBlock,
IWrenchable,
IHud {
    public EnergizingRodBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN));
        this.shapes.put(Direction.UP, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0), (VoxelShape)EnergizingRodBlock.box(7.25, 9.0, 7.25, 8.75, 13.0, 8.75), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.DOWN, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 0.0, 7.0, 9.0, 3.0, 9.0), (VoxelShape)EnergizingRodBlock.box(7.25, 3.0, 7.25, 8.75, 7.0, 8.75), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.NORTH, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 0.0, 9.0, 9.0, 3.0), (VoxelShape)EnergizingRodBlock.box(7.25, 7.25, 3.0, 8.75, 8.75, 7.0), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.SOUTH, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 13.0, 9.0, 9.0, 16.0), (VoxelShape)EnergizingRodBlock.box(7.25, 7.25, 13.0, 8.75, 8.75, 9.0), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.WEST, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(0.0, 7.0, 7.0, 3.0, 9.0, 9.0), (VoxelShape)EnergizingRodBlock.box(3.0, 7.25, 7.25, 7.0, 8.75, 8.75), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
        this.shapes.put(Direction.EAST, Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.m_83113_((VoxelShape)EnergizingRodBlock.box(13.0, 7.0, 7.0, 16.0, 9.0, 9.0), (VoxelShape)EnergizingRodBlock.box(13.0, 7.25, 7.25, 9.0, 8.75, 8.75), (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable CreativeModeTab group) {
        return super.getBlockItem(properties.m_41487_(1), group);
    }

    @Override
    public EnergyConfig getConfig() {
        return Powah.config().devices.energizing_rods;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnergizingRodTile(pos, state, (Tier)this.variant);
    }

    @Override
    protected boolean checkValidEnergySide() {
        return true;
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(Level worldIn, BlockPos pos, EnergizingRodTile tile) {
        int range = Powah.config().general.energizing_range;
        List list = BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).map(BlockPos::m_7949_).collect(Collectors.toList());
        for (BlockPos pos1 : list) {
            BlockEntity tileEntity1;
            if (pos1.equals((Object)BlockPos.f_121853_) || !((tileEntity1 = worldIn.m_7702_(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    @Override
    public boolean onWrench(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, WrenchMode mode, Vec3 hit) {
        ItemStack stack;
        if (mode.link() && (stack = player.m_21120_(hand)).m_41720_() instanceof WrenchItem) {
            WrenchItem wrench = (WrenchItem)stack.m_41720_();
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof EnergizingRodTile) {
                EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
                CompoundTag nbt = wrench.getWrenchNBT(stack);
                if (nbt.m_128425_("OrbPos", 10)) {
                    BlockPos orbPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("OrbPos"));
                    BlockEntity tileEntity1 = world.m_7702_(orbPos);
                    if (tileEntity1 instanceof EnergizingOrbTile) {
                        EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity1;
                        V3d v3d = V3d.from(orbPos);
                        if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                            rod.setOrbPos(orbPos);
                            player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.done").m_130940_(ChatFormatting.GOLD), true);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.fail").m_130940_(ChatFormatting.RED), true);
                        }
                    }
                    nbt.m_128473_("OrbPos");
                } else {
                    nbt.m_128365_("RodPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    player.m_5661_((Component)Component.m_237115_((String)"chat.powah.wrench.link.start").m_130940_(ChatFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(PoseStack matrix, BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result, @Nullable BlockEntity te) {
        if (te instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)te;
            RenderSystem.m_157191_().m_85836_();
            RenderSystem.m_69478_();
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            int x = mc.m_91268_().m_85445_() / 2;
            int y = mc.m_91268_().m_85446_();
            String s = ChatFormatting.GRAY + I18n.m_118938_((String)"info.lollipop.stored", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(rod.getEnergy().getEnergyStored()), Util.numFormat(rod.getEnergy().getCapacity())});
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("lollipop", "textures/gui/ov_energy.png"));
            Draw.drawTexturedModalRect(matrix, x - 37 - 1, y - 80, 0, 0, 74, 9, 0.0f);
            Draw.gaugeH(x - 37, y - 79, 72, 16, 0, 9, ((EnergizingRodTile)te).getEnergy());
            font.m_92750_(matrix, s, (float)x - (float)font.m_92895_(s) / 2.0f, (float)(y - 67), 0xFFFFFF);
            RenderSystem.m_69461_();
            RenderSystem.m_157191_().m_85849_();
        }
        return true;
    }
}

