/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.solar.SolarBlock;
import owmii.powah.item.Itms;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Misc;

public class SolarTile
extends AbstractEnergyProvider<SolarBlock>
implements IInventoryHolder {
    public static final String CAN_SEE_SKY = "can_see_sky";
    public static final String HAS_LENS_OF_ENDER = "has_lens_of_ender";
    private boolean canSeeSky;
    private boolean hasLensOfEnder;

    public SolarTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.SOLAR_PANEL.get(), pos, state, variant);
        this.inv.add(1);
    }

    public SolarTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag compound) {
        super.readSync(compound);
        this.canSeeSky = compound.m_128471_(CAN_SEE_SKY);
        this.hasLensOfEnder = compound.m_128471_(HAS_LENS_OF_ENDER);
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound) {
        compound.m_128379_(CAN_SEE_SKY, this.canSeeSky);
        compound.m_128379_(HAS_LENS_OF_ENDER, this.hasLensOfEnder);
        return super.writeSync(compound);
    }

    @Override
    protected int postTick(Level world) {
        boolean flag;
        if (this.isRemote()) {
            return -1;
        }
        boolean bl = flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        if (this.checkRedstone()) {
            boolean canSeeSkyNow;
            if (!this.hasLensOfEnder && (long)this.ticks % 40L == 0L && this.canSeeSky != (canSeeSkyNow = Misc.canBlockSeeSky(world, this.f_58858_.m_7494_()))) {
                this.canSeeSky = canSeeSkyNow;
                this.sync();
            }
            if (!this.energy.isFull() && (this.canSeeSky || this.hasLensOfEnder) && world.m_6042_().f_223549_() && world.m_7445_() < 4) {
                this.energy.produce(this.getGeneration());
                flag = true;
            }
        }
        return flag ? 5 : -1;
    }

    @Override
    public void onRemoved(Level world, BlockState state, BlockState newState, boolean isMoving) {
        super.onRemoved(world, state, newState, isMoving);
        if (state.m_60734_() != newState.m_60734_() && this.hasLensOfEnder) {
            Block.m_49840_((Level)world, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)Itms.LENS_OF_ENDER.get()));
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return Direction.DOWN.equals((Object)side);
    }

    public boolean hasLensOfEnder() {
        return this.hasLensOfEnder;
    }

    public void setHasLensOfEnder(boolean hasLensOfEnder) {
        this.hasLensOfEnder = hasLensOfEnder;
        this.sync();
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

