/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.EnvHandler;
import owmii.powah.block.Tier;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.logistics.IRedstoneInteract;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.energy.SideConfig;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Util;

public abstract class AbstractEnergyStorage<C extends IEnergyConfig<Tier>, B extends AbstractEnergyBlock<C, B>>
extends AbstractTickableTile<Tier, B>
implements IRedstoneInteract {
    protected final SideConfig sideConfig = new SideConfig(this);
    protected final Energy energy = Energy.create(0L);

    public AbstractEnergyStorage(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, (Tier)IVariant.getEmpty());
    }

    public AbstractEnergyStorage(BlockEntityType<?> type, BlockPos pos, BlockState state, Tier variant) {
        super(type, pos, state, variant);
    }

    @Override
    public void readSync(CompoundTag nbt) {
        this.sideConfig.read(nbt);
        if (!this.keepEnergy()) {
            this.energy.read(nbt, true, false);
        }
        super.readSync(nbt);
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt) {
        this.sideConfig.write(nbt);
        if (!this.keepEnergy()) {
            this.energy.write(nbt, true, false);
        }
        return super.writeSync(nbt);
    }

    @Override
    public void readStorable(CompoundTag nbt) {
        if (this.keepEnergy()) {
            this.energy.read(nbt, false, false);
        }
        super.readStorable(nbt);
    }

    @Override
    public CompoundTag writeStorable(CompoundTag nbt) {
        if (this.keepEnergy()) {
            this.energy.write(nbt, false, false);
        }
        return super.writeStorable(nbt);
    }

    public boolean keepEnergy() {
        return false;
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        this.energy.setCapacity(this.getEnergyCapacity());
        this.energy.setTransfer(this.getEnergyTransfer());
        this.getSideConfig().init();
        this.sync();
    }

    protected long extractFromSides(Level world) {
        long extracted = 0L;
        if (!this.isRemote()) {
            for (Direction side : Direction.values()) {
                if (!this.canExtractEnergy(side)) continue;
                long amount = Math.min(this.getEnergyTransfer(), this.getEnergy().getStored());
                long toExtract = EnvHandler.INSTANCE.pushEnergy(world, this.f_58858_.m_121945_(side), side.m_122424_(), amount);
                extracted += this.extractEnergy(Util.safeInt(toExtract), false, side);
            }
        }
        return extracted;
    }

    protected long chargeItems(int i) {
        return this.chargeItems(0, i);
    }

    protected long chargeItems(int i, int j) {
        Energy energy = this.getEnergy();
        long charged = EnvHandler.INSTANCE.chargeItemsInInventory(this.inv, i, j, this.getEnergyTransfer(), energy.getStored());
        energy.consume(charged);
        return charged;
    }

    public long extractEnergy(long maxExtract, boolean simulate, @Nullable Direction side) {
        if (!this.canExtractEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long extracted = Math.min(energy.getStored(), Math.min(energy.getMaxExtract(), maxExtract));
        if (!simulate && extracted > 0L) {
            energy.consume(extracted);
            this.sync(10);
        }
        return extracted;
    }

    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable Direction side) {
        if (!this.canReceiveEnergy(side)) {
            return 0L;
        }
        Energy energy = this.getEnergy();
        long received = Math.min(energy.getEmpty(), Math.min(energy.getMaxReceive(), maxReceive));
        if (!simulate && received > 0L) {
            energy.produce(received);
            this.sync(10);
        }
        return received;
    }

    public boolean canExtractEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canExtract;
    }

    public boolean canReceiveEnergy(@Nullable Direction side) {
        return side == null || this.isEnergyPresent(side) && this.sideConfig.getType((Direction)side).canReceive;
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return true;
    }

    @Override
    public void onAdded(Level world, BlockState state, BlockState oldState, boolean isMoving) {
        super.onAdded(world, state, oldState, isMoving);
        if (state.m_60734_() != oldState.m_60734_()) {
            this.getSideConfig().init();
        }
    }

    protected long getEnergyCapacity() {
        return this.getConfig().getCapacity((Tier)((Tier)this.getVariant()));
    }

    protected long getEnergyTransfer() {
        return this.getConfig().getTransfer((Tier)((Tier)this.getVariant()));
    }

    protected C getConfig() {
        return (C)((IEnergyConfig)((AbstractEnergyBlock)this.getBlock()).getConfig());
    }

    public Energy getEnergy() {
        return this.energy;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }
}

