/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.util;

import dev.architectury.fluid.FluidStack;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import owmii.powah.lib.logistics.fluid.Tank;

public class Util {
    static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();

    public static boolean anyMatch(int[] arr, int value) {
        return Arrays.stream(arr).anyMatch(i -> i == value);
    }

    public static boolean anyMatch(long[] arr, long value) {
        return Arrays.stream(arr).anyMatch(i -> i == value);
    }

    public static int safeInt(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
    }

    public static int safeInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long safeLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static MutableComponent formatTankContent(Tank tank) {
        return Util.formatTankContent(tank.getFluidAmount(), tank.getCapacity());
    }

    public static MutableComponent formatTankContent(long amount, long capacity) {
        return Component.m_237110_((String)"info.lollipop.mb.stored", (Object[])new Object[]{Util.addCommas(Util.amountToMillibuckets(amount)), Util.numFormat(Util.amountToMillibuckets(capacity))}).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static int millibucketAmount() {
        return (int)(FluidStack.bucketAmount() / 1000L);
    }

    public static long amountToMillibuckets(long amount) {
        long result = amount * 1000L / FluidStack.bucketAmount();
        if (result == 0L && amount != 0L) {
            return amount >= 0L ? 1L : -1L;
        }
        return result;
    }

    public static String numFormat(long value) {
        if (value == Long.MIN_VALUE) {
            return Util.numFormat(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Util.numFormat(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = SUFFIXES.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String addCommas(long value) {
        return NumberFormat.getInstance(Locale.ROOT).format(value);
    }

    static {
        SUFFIXES.put(1000L, "k");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "B");
        SUFFIXES.put(1000000000000L, "T");
        SUFFIXES.put(1000000000000000L, "P");
        SUFFIXES.put(1000000000000000000L, "E");
    }
}

