/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPulleyRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T> {
    private PartialModel halfRope;
    private PartialModel halfMagnet;

    public AbstractPulleyRenderer(BlockEntityRendererProvider.Context context, PartialModel halfRope, PartialModel halfMagnet) {
        super(context);
        this.halfRope = halfRope;
        this.halfMagnet = halfMagnet;
    }

    public boolean shouldRenderOffScreen(T p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(T be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float offset = this.getOffset(be, partialTicks);
        boolean running = this.isRunning(be);
        Direction.Axis rotationAxis = ((IRotate)be.m_58900_().m_60734_()).getRotationAxis(be.m_58900_());
        AbstractPulleyRenderer.kineticRotationTransform(this.getRotatedCoil(be), be, rotationAxis, AngleHelper.rad(offset * 180.0f), light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        Level world = be.m_58904_();
        BlockState blockState = be.m_58900_();
        BlockPos pos = be.m_58899_();
        SuperByteBuffer halfMagnet = CachedBufferer.partial(this.halfMagnet, blockState);
        SuperByteBuffer halfRope = CachedBufferer.partial(this.halfRope, blockState);
        SuperByteBuffer magnet = this.renderMagnet(be);
        SuperByteBuffer rope = this.renderRope(be);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        if (running || offset == 0.0f) {
            AbstractPulleyRenderer.renderAt((LevelAccessor)world, offset > 0.25f ? magnet : halfMagnet, offset, pos, ms, vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            AbstractPulleyRenderer.renderAt((LevelAccessor)world, halfRope, f > 0.75f ? f - 1.0f : f, pos, ms, vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            AbstractPulleyRenderer.renderAt((LevelAccessor)world, rope, offset - (float)i - 1.0f, pos, ms, vb);
            ++i;
        }
    }

    public static void renderAt(LevelAccessor world, SuperByteBuffer partial, float offset, BlockPos pulleyPos, PoseStack ms, VertexConsumer buffer) {
        BlockPos actualPos = pulleyPos.m_6625_((int)offset);
        int light = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)world.m_8055_(actualPos), (BlockPos)actualPos);
        partial.translate(0.0, -offset, 0.0).light(light).renderInto(ms, buffer);
    }

    protected abstract Direction.Axis getShaftAxis(T var1);

    protected abstract PartialModel getCoil();

    protected abstract SuperByteBuffer renderRope(T var1);

    protected abstract SuperByteBuffer renderMagnet(T var1);

    protected abstract float getOffset(T var1, float var2);

    protected abstract boolean isRunning(T var1);

    @Override
    protected BlockState getRenderedBlockState(T be) {
        return AbstractPulleyRenderer.shaft(this.getShaftAxis(be));
    }

    protected SuperByteBuffer getRotatedCoil(T be) {
        BlockState blockState = be.m_58900_();
        return CachedBufferer.partialFacing(this.getCoil(), blockState, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getShaftAxis(be)));
    }

    public int m_142163_() {
        return 256;
    }
}

