/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.pulley.PulleyLighter;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PulleyContraption
extends TranslatingContraption {
    int initialOffset;

    @Override
    public ContraptionType getType() {
        return ContraptionType.PULLEY;
    }

    public PulleyContraption() {
    }

    public PulleyContraption(int initialOffset) {
        this.initialOffset = initialOffset;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        this.startMoving(world);
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        if (pos.m_123341_() != this.anchor.m_123341_() || pos.m_123343_() != this.anchor.m_123343_()) {
            return false;
        }
        int y = pos.m_123342_();
        return y > this.anchor.m_123342_() && y <= this.anchor.m_123342_() + this.initialOffset + 1;
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("InitialOffset", this.initialOffset);
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag nbt, boolean spawnData) {
        this.initialOffset = nbt.m_128451_("InitialOffset");
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new PulleyLighter(this);
    }

    public int getInitialOffset() {
        return this.initialOffset;
    }
}

