/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crank;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HandCrankInstance
extends SingleRotatingInstance<HandCrankBlockEntity>
implements DynamicInstance {
    private ModelData crank;
    private Direction facing;

    public HandCrankInstance(MaterialManager modelManager, HandCrankBlockEntity blockEntity) {
        super(modelManager, blockEntity);
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Instancer<ModelData> model = blockEntity.getRenderedHandleInstance((Material<ModelData>)this.getTransformMaterial());
        this.crank = (ModelData)model.createInstance();
        this.rotateCrank();
    }

    public void beginFrame() {
        if (this.crank == null) {
            return;
        }
        this.rotateCrank();
    }

    private void rotateCrank() {
        Direction.Axis axis = this.facing.m_122434_();
        float angle = ((HandCrankBlockEntity)this.blockEntity).getIndependentAngle(AnimationTickHolder.getPartialTicks());
        ((ModelData)((ModelData)((ModelData)this.crank.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle)).unCentre();
    }

    @Override
    public void init() {
        if (((HandCrankBlockEntity)this.blockEntity).shouldRenderShaft()) {
            super.init();
        }
    }

    @Override
    public void remove() {
        if (((HandCrankBlockEntity)this.blockEntity).shouldRenderShaft()) {
            super.remove();
        }
        if (this.crank != null) {
            this.crank.delete();
        }
    }

    @Override
    public void update() {
        if (((HandCrankBlockEntity)this.blockEntity).shouldRenderShaft()) {
            super.update();
        }
    }

    @Override
    public void updateLight() {
        if (((HandCrankBlockEntity)this.blockEntity).shouldRenderShaft()) {
            super.updateLight();
        }
        if (this.crank != null) {
            this.relight(this.pos, new FlatLit[]{this.crank});
        }
    }
}

