/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.mojang.authlib.GameProfile;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class DeployerFakePlayer
extends FakePlayer {
    private static final Connection NETWORK_MANAGER = new Connection(PacketFlow.CLIENTBOUND);
    public static final UUID fallbackID = UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d");
    Pair<BlockPos, Float> blockBreakingProgress;
    ItemStack spawnedItemEffects;
    public boolean placedTracks;
    public boolean onMinecartContraption;
    private UUID owner;

    public DeployerFakePlayer(ServerLevel world, @Nullable UUID owner) {
        super(world, (GameProfile)new DeployerGameProfile(fallbackID, "Deployer", owner));
        this.f_8906_ = new FakePlayNetHandler(world.m_7654_(), (ServerPlayer)this);
        this.owner = owner;
    }

    public OptionalInt m_5893_(MenuProvider menuProvider) {
        return OptionalInt.empty();
    }

    public Component m_5446_() {
        return Lang.translateDirect("block.deployer.damage_source_name", new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_20236_(Pose poseIn) {
        return 0.0f;
    }

    public Vec3 m_20182_() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public float m_36333_() {
        return 0.015625f;
    }

    public boolean m_36391_(boolean ignoreHunger) {
        return false;
    }

    public ItemStack m_5584_(Level world, ItemStack stack) {
        stack.m_41774_(1);
        return stack;
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public UUID m_20148_() {
        return this.owner == null ? super.m_20148_() : this.owner;
    }

    @SubscribeEvent
    public static void deployerHasEyesOnHisFeet(EntityEvent.Size event) {
        if (event.getEntity() instanceof DeployerFakePlayer) {
            event.setNewEyeHeight(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void deployerCollectsDropsFromKilledEntities(LivingDropsEvent event) {
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        EntityDamageSource source = (EntityDamageSource)event.getSource();
        Entity trueSource = source.m_7639_();
        if (trueSource != null && trueSource instanceof DeployerFakePlayer) {
            DeployerFakePlayer fakePlayer = (DeployerFakePlayer)trueSource;
            event.getDrops().forEach(stack -> fakePlayer.m_150109_().m_150079_(stack.m_32055_()));
            event.setCanceled(true);
        }
    }

    protected boolean m_213772_(EquipmentSlot p_217035_) {
        return false;
    }

    protected void m_217041_(ItemStack p_217042_) {
    }

    public void m_142687_(Entity.RemovalReason p_150097_) {
        if (this.blockBreakingProgress != null && !this.f_19853_.f_46443_) {
            this.f_19853_.m_6801_(this.m_19879_(), (BlockPos)this.blockBreakingProgress.getKey(), -1);
        }
        super.m_142687_(p_150097_);
    }

    @SubscribeEvent
    public static void deployerKillsDoNotSpawnXP(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof DeployerFakePlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void entitiesDontRetaliate(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof DeployerFakePlayer)) {
            return;
        }
        LivingEntity entityLiving = event.getEntity();
        if (!(entityLiving instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entityLiving;
        CKinetics.DeployerAggroSetting setting = (CKinetics.DeployerAggroSetting)((Object)AllConfigs.server().kinetics.ignoreDeployerAttacks.get());
        switch (setting) {
            case ALL: {
                mob.m_6710_(null);
                break;
            }
            case CREEPERS: {
                if (!(mob instanceof Creeper)) break;
                mob.m_6710_(null);
                break;
            }
        }
    }

    private static class DeployerGameProfile
    extends GameProfile {
        private UUID owner;

        public DeployerGameProfile(UUID id, String name, UUID owner) {
            super(id, name);
            this.owner = owner;
        }

        public UUID getId() {
            return this.owner == null ? super.getId() : this.owner;
        }

        public String getName() {
            if (this.owner == null) {
                return super.getName();
            }
            String lastKnownUsername = UsernameCache.getLastKnownUsername((UUID)this.owner);
            return lastKnownUsername == null ? super.getName() : lastKnownUsername;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GameProfile)) {
                return false;
            }
            GameProfile otherProfile = (GameProfile)o;
            return Objects.equals(this.getId(), otherProfile.getId()) && Objects.equals(this.getName(), otherProfile.getName());
        }

        public int hashCode() {
            UUID id = this.getId();
            String name = this.getName();
            int result = id == null ? 0 : id.hashCode();
            result = 31 * result + (name == null ? 0 : name.hashCode());
            return result;
        }
    }

    private static class FakePlayNetHandler
    extends ServerGamePacketListenerImpl {
        public FakePlayNetHandler(MinecraftServer server, ServerPlayer playerIn) {
            super(server, NETWORK_MANAGER, playerIn);
        }

        public void m_9829_(Packet<?> packetIn) {
        }

        public void m_243119_(Packet<?> p_243227_, @Nullable PacketSendListener p_243273_) {
        }
    }
}

