/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.diodes;

import com.simibubi.create.content.redstone.diodes.ToggleLatchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;

public class PoweredLatchBlock
extends ToggleLatchBlock {
    public static BooleanProperty POWERED_SIDE = BooleanProperty.m_61465_((String)"powered_side");

    public PoweredLatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED_SIDE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWERED_SIDE}));
    }

    protected void m_7321_(Level worldIn, BlockPos pos, BlockState state) {
        boolean back = (Boolean)state.m_61143_((Property)f_52496_);
        boolean shouldBack = this.m_7320_(worldIn, pos, state);
        boolean side = (Boolean)state.m_61143_((Property)POWERED_SIDE);
        boolean shouldSide = this.isPoweredOnSides(worldIn, pos, state);
        TickPriority tickpriority = TickPriority.HIGH;
        if (this.m_52573_((BlockGetter)worldIn, pos, state)) {
            tickpriority = TickPriority.EXTREMELY_HIGH;
        } else if (side || back) {
            tickpriority = TickPriority.VERY_HIGH;
        }
        if (worldIn.m_183326_().m_183588_(pos, (Object)this)) {
            return;
        }
        if (back != shouldBack || side != shouldSide) {
            worldIn.m_186464_(pos, (Block)this, this.m_6112_(state), tickpriority);
        }
    }

    protected boolean isPoweredOnSides(Level worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        Direction left = direction.m_122427_();
        Direction right = direction.m_122428_();
        for (Direction d : new Direction[]{left, right}) {
            BlockPos blockpos = pos.m_121945_(d);
            int i = worldIn.m_46681_(blockpos, d);
            if (i > 0) {
                return true;
            }
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if (blockstate.m_60734_() != Blocks.f_50088_ || (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean back = (Boolean)state.m_61143_((Property)f_52496_);
        boolean shouldBack = this.m_7320_((Level)worldIn, pos, state);
        boolean side = (Boolean)state.m_61143_((Property)POWERED_SIDE);
        boolean shouldSide = this.isPoweredOnSides((Level)worldIn, pos, state);
        BlockState stateIn = state;
        if (back != shouldBack) {
            state = (BlockState)state.m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(shouldBack));
            if (shouldBack) {
                state = (BlockState)state.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(true));
            } else if (side) {
                state = (BlockState)state.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false));
            }
        }
        if (side != shouldSide) {
            state = (BlockState)state.m_61124_((Property)POWERED_SIDE, (Comparable)Boolean.valueOf(shouldSide));
            if (shouldSide) {
                state = (BlockState)state.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(false));
            } else if (back) {
                state = (BlockState)state.m_61124_((Property)POWERING, (Comparable)Boolean.valueOf(true));
            }
        }
        if (state != stateIn) {
            worldIn.m_7731_(pos, state, 2);
        }
    }

    @Override
    protected InteractionResult activated(Level worldIn, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_52496_) != state.m_61143_((Property)POWERED_SIDE)) {
            return InteractionResult.PASS;
        }
        if (!worldIn.f_46443_) {
            float f = (Boolean)state.m_61143_((Property)POWERING) == false ? 0.6f : 0.5f;
            worldIn.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERING), 2);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        return side.m_122434_().m_122479_();
    }
}

