/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.cannon;

import com.google.common.collect.Sets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public static final int MAX_ENTRIES_PER_CLIPBOARD_PAGE = 7;
    public Object2IntMap<Item> gathered = new Object2IntArrayMap();
    public Object2IntMap<Item> required = new Object2IntArrayMap();
    public Object2IntMap<Item> damageRequired = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemRequirement.StackRequirement stack : requirement.getRequiredItems()) {
            if (stack.usage == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack.stack);
            }
            if (stack.usage != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack.stack);
        }
    }

    private void putOrIncrement(Object2IntMap<Item> map, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_41852_) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.m_41613_());
        } else {
            map.put((Object)item, stack.m_41613_());
        }
    }

    public void collect(ItemStack stack) {
        Item item = stack.m_41720_();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            if (this.gathered.containsKey((Object)item)) {
                this.gathered.put((Object)item, this.gathered.getInt((Object)item) + stack.m_41613_());
            } else {
                this.gathered.put((Object)item, stack.m_41613_());
            }
        }
    }

    public ItemStack createWrittenBook() {
        MutableComponent textComponent;
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        CompoundTag tag = book.m_41784_();
        ListTag pages = new ListTag();
        int itemsWritten = 0;
        if (this.blocksNotLoaded) {
            textComponent = Components.literal("\n" + ChatFormatting.RED);
            textComponent = textComponent.m_7220_((Component)Lang.translateDirect("materialChecklist.blocksNotLoaded", new Object[0]));
            pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.m_41466_().getString().toLowerCase(locale);
            String name2 = item2.m_41466_().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        textComponent = Components.empty();
        ArrayList<Item> completed = new ArrayList<Item>();
        for (Item item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.m_7220_((Component)Components.literal("\n >>>").m_130940_(ChatFormatting.BLUE));
                pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
                textComponent = Components.empty();
            }
            ++itemsWritten;
            textComponent.m_7220_((Component)this.entry(new ItemStack((ItemLike)item), amount, true, true));
        }
        for (Item item : completed) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent.m_7220_((Component)Components.literal("\n >>>").m_130940_(ChatFormatting.DARK_GREEN));
                pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
                textComponent = Components.empty();
            }
            ++itemsWritten;
            textComponent.m_7220_((Component)this.entry(new ItemStack((ItemLike)item), this.getRequiredAmount(item), false, true));
        }
        pages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)textComponent)));
        tag.m_128365_("pages", (Tag)pages);
        tag.m_128379_("readonly", true);
        tag.m_128359_("author", "Schematicannon");
        tag.m_128359_("title", ChatFormatting.BLUE + "Material Checklist");
        textComponent = Lang.translateDirect("materialChecklist", new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.FALSE));
        book.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)textComponent));
        book.m_41751_(tag);
        return book;
    }

    public ItemStack createWrittenClipboard() {
        ItemStack clipboard = AllBlocks.CLIPBOARD.asStack();
        CompoundTag tag = clipboard.m_41784_();
        int itemsWritten = 0;
        ArrayList<List<ClipboardEntry>> pages = new ArrayList<List<ClipboardEntry>>();
        ArrayList<ClipboardEntry> currentPage = new ArrayList<ClipboardEntry>();
        if (this.blocksNotLoaded) {
            currentPage.add(new ClipboardEntry(false, Lang.translateDirect("materialChecklist.blocksNotLoaded", new Object[0]).m_130940_(ChatFormatting.RED)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = item1.m_41466_().getString().toLowerCase(locale);
            String name2 = item2.m_41466_().getString().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        ArrayList<Item> completed = new ArrayList<Item>();
        for (Item item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(false, Components.literal(">>>").m_130940_(ChatFormatting.DARK_GRAY)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(false, this.entry(new ItemStack((ItemLike)item), amount, true, false)).displayItem(new ItemStack((ItemLike)item)));
        }
        for (Item item : completed) {
            if (itemsWritten == 7) {
                itemsWritten = 0;
                currentPage.add(new ClipboardEntry(true, Components.literal(">>>").m_130940_(ChatFormatting.DARK_GREEN)));
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            ++itemsWritten;
            currentPage.add(new ClipboardEntry(true, this.entry(new ItemStack((ItemLike)item), this.getRequiredAmount(item), false, false)).displayItem(new ItemStack((ItemLike)item)));
        }
        pages.add(currentPage);
        ClipboardEntry.saveAll(pages, clipboard);
        ClipboardOverrides.switchTo(ClipboardOverrides.ClipboardType.WRITTEN, clipboard);
        clipboard.m_41698_("display").m_128359_("Name", Component.Serializer.m_130703_((Component)Lang.translateDirect("materialChecklist", new Object[0]).m_6270_(Style.f_131099_.m_131155_(Boolean.FALSE))));
        tag.m_128379_("Readonly", true);
        clipboard.m_41751_(tag);
        return clipboard;
    }

    public int getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new ItemStack((ItemLike)item).m_41776_()));
        }
        return amount;
    }

    private MutableComponent entry(ItemStack item, int amount, boolean unfinished, boolean forBook) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        MutableComponent tc = Components.empty();
        tc.m_7220_((Component)Components.translatable(item.m_41778_()).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(item)))));
        if (!unfinished && forBook) {
            tc.m_130946_(" \u2714");
        }
        if (!unfinished || forBook) {
            tc.m_130940_(unfinished ? ChatFormatting.BLUE : ChatFormatting.DARK_GREEN);
        }
        return tc.m_7220_((Component)Components.literal("\n x" + amount).m_130940_(ChatFormatting.BLACK)).m_7220_((Component)Components.literal(" | " + stacks + "\u25a4 +" + remainder + (forBook ? "\n" : "")).m_130940_(ChatFormatting.GRAY));
    }
}

