/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsHandler;
import com.simibubi.create.content.trains.HonkPacket;
import com.simibubi.create.content.trains.TrainHUDUpdatePacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class TrainHUD {
    public static final IGuiOverlay OVERLAY = TrainHUD::renderOverlay;
    static LerpedFloat displayedSpeed = LerpedFloat.linear();
    static LerpedFloat displayedThrottle = LerpedFloat.linear();
    static LerpedFloat displayedPromptSize = LerpedFloat.linear();
    static Double editedThrottle = null;
    static int hudPacketCooldown = 5;
    static int honkPacketCooldown = 5;
    public static Component currentPrompt;
    public static boolean currentPromptShadow;
    public static int promptKeepAlive;
    static boolean usedToHonk;

    public static void tick() {
        if (promptKeepAlive > 0) {
            --promptKeepAlive;
        } else {
            currentPrompt = null;
        }
        Minecraft mc = Minecraft.m_91087_();
        displayedPromptSize.chase(currentPrompt != null ? (double)(mc.f_91062_.m_92852_((FormattedText)currentPrompt) + 17) : 0.0, 0.5, LerpedFloat.Chaser.EXP);
        displayedPromptSize.tickChaser();
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return;
        }
        Train train = carriage.train;
        double value = Math.abs(train.speed) / (double)(train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF());
        value = Mth.m_14008_((double)(value + (double)0.05f), (double)0.0, (double)1.0);
        displayedSpeed.chase((float)((int)(value * 18.0)) / 18.0f, 0.5, LerpedFloat.Chaser.EXP);
        displayedSpeed.tickChaser();
        displayedThrottle.chase(editedThrottle != null ? editedThrottle : train.throttle, 0.75, LerpedFloat.Chaser.EXP);
        displayedThrottle.tickChaser();
        boolean isSprintKeyPressed = ControlsUtil.isActuallyPressed(mc.f_91066_.f_92091_);
        if (isSprintKeyPressed && honkPacketCooldown-- <= 0) {
            train.determineHonk((Level)mc.f_91073_);
            if (train.lowHonk != null) {
                AllPackets.getChannel().sendToServer((Object)new HonkPacket.Serverbound(train, true));
                honkPacketCooldown = 5;
                usedToHonk = true;
            }
        }
        if (!isSprintKeyPressed && usedToHonk) {
            AllPackets.getChannel().sendToServer((Object)new HonkPacket.Serverbound(train, false));
            honkPacketCooldown = 0;
            usedToHonk = false;
        }
        if (editedThrottle == null) {
            return;
        }
        if (Mth.m_14082_((double)editedThrottle, (double)train.throttle)) {
            editedThrottle = null;
            hudPacketCooldown = 5;
            return;
        }
        if (hudPacketCooldown-- <= 0) {
            AllPackets.getChannel().sendToServer((Object)new TrainHUDUpdatePacket.Serverbound(train, editedThrottle));
            hudPacketCooldown = 5;
        }
    }

    private static Carriage getCarriage() {
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        return cce.getCarriage();
    }

    public static void renderOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (cameraEntity == null) {
            return;
        }
        BlockPos localPos = ControlsHandler.getControlsPos();
        if (localPos == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)(width / 2 - 91), (double)(height - 29), 0.0);
        AllGuiTextures.TRAIN_HUD_FRAME.render(poseStack, -2, 1);
        AllGuiTextures.TRAIN_HUD_SPEED_BG.render(poseStack, 0, 0);
        int w = (int)((float)AllGuiTextures.TRAIN_HUD_SPEED.width * displayedSpeed.getValue(partialTicks));
        int h = AllGuiTextures.TRAIN_HUD_SPEED.height;
        AllGuiTextures.TRAIN_HUD_SPEED.bind();
        GuiComponent.m_93143_((PoseStack)poseStack, (int)0, (int)0, (int)0, (float)AllGuiTextures.TRAIN_HUD_SPEED.startX, (float)AllGuiTextures.TRAIN_HUD_SPEED.startY, (int)w, (int)h, (int)256, (int)256);
        int promptSize = (int)displayedPromptSize.getValue(partialTicks);
        if (promptSize > 1) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)promptSize / -2.0f + 91.0f), -27.0, 100.0);
            AllGuiTextures.TRAIN_PROMPT_L.render(poseStack, -3, 0);
            AllGuiTextures.TRAIN_PROMPT_R.render(poseStack, promptSize, 0);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)0, (int)0, (int)0, (float)((float)AllGuiTextures.TRAIN_PROMPT.startX + (128.0f - (float)promptSize / 2.0f)), (float)AllGuiTextures.TRAIN_PROMPT.startY, (int)promptSize, (int)AllGuiTextures.TRAIN_PROMPT.height, (int)256, (int)256);
            poseStack.m_85849_();
            Font font = mc.f_91062_;
            if (currentPrompt != null && font.m_92852_((FormattedText)currentPrompt) < promptSize - 10) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)((float)font.m_92852_((FormattedText)currentPrompt) / -2.0f + 82.0f), -27.0, 100.0);
                if (currentPromptShadow) {
                    font.m_92763_(poseStack, currentPrompt, 9.0f, 4.0f, 0x544D45);
                } else {
                    font.m_92889_(poseStack, currentPrompt, 9.0f, 4.0f, 0x544D45);
                }
                poseStack.m_85849_();
            }
        }
        AllGuiTextures.TRAIN_HUD_DIRECTION.render(poseStack, 77, -20);
        w = (int)((float)AllGuiTextures.TRAIN_HUD_THROTTLE.width * (1.0f - displayedThrottle.getValue(partialTicks)));
        AllGuiTextures.TRAIN_HUD_THROTTLE.bind();
        int invW = AllGuiTextures.TRAIN_HUD_THROTTLE.width - w;
        GuiComponent.m_93143_((PoseStack)poseStack, (int)invW, (int)0, (int)0, (float)(AllGuiTextures.TRAIN_HUD_THROTTLE.startX + invW), (float)AllGuiTextures.TRAIN_HUD_THROTTLE.startY, (int)w, (int)h, (int)256, (int)256);
        AllGuiTextures.TRAIN_HUD_THROTTLE_POINTER.render(poseStack, Math.max(1, AllGuiTextures.TRAIN_HUD_THROTTLE.width - w) - 3, -2);
        StructureTemplate.StructureBlockInfo info = cce.getContraption().getBlocks().get(localPos);
        Direction initialOrientation = cce.getInitialOrientation().m_122428_();
        boolean inverted = false;
        if (info != null && info.f_74676_.m_61138_((Property)ControlsBlock.f_54117_)) {
            inverted = !((Direction)info.f_74676_.m_61143_((Property)ControlsBlock.f_54117_)).equals((Object)initialOrientation);
        }
        boolean reversing = ControlsHandler.currentlyPressed.contains(1);
        inverted ^= reversing;
        int angleOffset = (ControlsHandler.currentlyPressed.contains(2) ? -45 : 0) + (ControlsHandler.currentlyPressed.contains(3) ? 45 : 0);
        if (reversing) {
            angleOffset *= -1;
        }
        float snapSize = 22.5f;
        float diff = AngleHelper.getShortestAngleDiff(cameraEntity.m_146908_(), cce.yaw) + (float)(inverted ? -90 : 90);
        if (Math.abs(diff) < 60.0f) {
            diff = 0.0f;
        }
        float angle = diff + (float)angleOffset;
        float snappedAngle = snapSize * (float)Math.round(angle / snapSize) % 360.0f;
        poseStack.m_85837_(91.0, -9.0, 0.0);
        poseStack.m_85841_(0.925f, 0.925f, 1.0f);
        PlacementHelpers.textured(poseStack, 0.0f, 0.0f, 1.0f, snappedAngle);
        poseStack.m_85849_();
    }

    public static boolean onScroll(double delta) {
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return false;
        }
        double prevThrottle = editedThrottle == null ? carriage.train.throttle : editedThrottle;
        editedThrottle = Mth.m_14008_((double)(prevThrottle + (double)((float)(delta > 0.0 ? 1 : -1) / 18.0f)), (double)0.0555555559694767, (double)1.0);
        return true;
    }

    static {
        promptKeepAlive = 0;
    }
}

