/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.outliner.Outline;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBOutline
extends Outline {
    protected AABB bb;
    protected final Vector3f minPosTemp1 = new Vector3f();
    protected final Vector3f maxPosTemp1 = new Vector3f();
    protected final Vector4f colorTemp1 = new Vector4f();
    protected final Vector3f pos0Temp = new Vector3f();
    protected final Vector3f pos1Temp = new Vector3f();
    protected final Vector3f pos2Temp = new Vector3f();
    protected final Vector3f pos3Temp = new Vector3f();
    protected final Vector3f normalTemp = new Vector3f();
    protected final Vector3f originTemp = new Vector3f();

    public AABBOutline(AABB bb) {
        this.setBounds(bb);
    }

    public AABB getBounds() {
        return this.bb;
    }

    public void setBounds(AABB bb) {
        this.bb = bb;
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderBox(ms, buffer, camera, this.bb, color, lightmap, disableLineNormals);
    }

    protected void renderBox(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, AABB box, Vector4f color, int lightmap, boolean disableLineNormals) {
        Vector3f minPos = this.minPosTemp1;
        Vector3f maxPos = this.maxPosTemp1;
        boolean cameraInside = box.m_82390_(camera);
        boolean cull = !cameraInside && !this.params.disableCull;
        float inflate = cameraInside ? -0.0078125f : 0.0078125f;
        box = box.m_82383_(camera.m_82490_(-1.0));
        minPos.m_122245_((float)box.f_82288_ - inflate, (float)box.f_82289_ - inflate, (float)box.f_82290_ - inflate);
        maxPos.m_122245_((float)box.f_82291_ + inflate, (float)box.f_82292_ + inflate, (float)box.f_82293_ + inflate);
        this.renderBoxFaces(ms, buffer, cull, this.params.getHighlightedFace(), minPos, maxPos, color, lightmap);
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        VertexConsumer consumer = buffer.m_6299_(RenderTypes.getOutlineSolid());
        this.renderBoxEdges(ms, consumer, minPos, maxPos, lineWidth, color, lightmap, disableLineNormals);
    }

    protected void renderBoxFaces(PoseStack ms, SuperRenderTypeBuffer buffer, boolean cull, Direction highlightedFace, Vector3f minPos, Vector3f maxPos, Vector4f color, int lightmap) {
        PoseStack.Pose pose = ms.m_85850_();
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.DOWN, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.UP, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.NORTH, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.SOUTH, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.WEST, color, lightmap);
        this.renderBoxFace(pose, buffer, cull, highlightedFace, minPos, maxPos, Direction.EAST, color, lightmap);
    }

    protected void renderBoxFace(PoseStack.Pose pose, SuperRenderTypeBuffer buffer, boolean cull, Direction highlightedFace, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color, int lightmap) {
        boolean highlighted = face == highlightedFace;
        Optional<AllSpecialTextures> optionalFaceTexture = this.params.faceTexture;
        if (!optionalFaceTexture.isPresent()) {
            return;
        }
        AllSpecialTextures faceTexture = optionalFaceTexture.get();
        RenderType renderType = RenderTypes.getOutlineTranslucent(faceTexture.getLocation(), cull);
        VertexConsumer consumer = buffer.getLateBuffer(renderType);
        float alphaMult = highlighted ? 1.0f : 0.5f;
        this.colorTemp1.m_123602_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_() * alphaMult);
        color = this.colorTemp1;
        this.renderBoxFace(pose, consumer, minPos, maxPos, face, color, lightmap);
    }

    protected void renderBoxFace(PoseStack.Pose pose, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color, int lightmap) {
        float maxV;
        float maxU;
        Vector3f pos0 = this.pos0Temp;
        Vector3f pos1 = this.pos1Temp;
        Vector3f pos2 = this.pos2Temp;
        Vector3f pos3 = this.pos3Temp;
        Vector3f normal = this.normalTemp;
        float minX = minPos.m_122239_();
        float minY = minPos.m_122260_();
        float minZ = minPos.m_122269_();
        float maxX = maxPos.m_122239_();
        float maxY = maxPos.m_122260_();
        float maxZ = maxPos.m_122269_();
        switch (face) {
            case DOWN: {
                pos0.m_122245_(minX, minY, maxZ);
                pos1.m_122245_(minX, minY, minZ);
                pos2.m_122245_(maxX, minY, minZ);
                pos3.m_122245_(maxX, minY, maxZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.m_122245_(0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                pos0.m_122245_(minX, maxY, minZ);
                pos1.m_122245_(minX, maxY, maxZ);
                pos2.m_122245_(maxX, maxY, maxZ);
                pos3.m_122245_(maxX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.m_122245_(0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                pos0.m_122245_(maxX, maxY, minZ);
                pos1.m_122245_(maxX, minY, minZ);
                pos2.m_122245_(minX, minY, minZ);
                pos3.m_122245_(minX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.m_122245_(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                pos0.m_122245_(minX, maxY, maxZ);
                pos1.m_122245_(minX, minY, maxZ);
                pos2.m_122245_(maxX, minY, maxZ);
                pos3.m_122245_(maxX, maxY, maxZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.m_122245_(0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                pos0.m_122245_(minX, maxY, minZ);
                pos1.m_122245_(minX, minY, minZ);
                pos2.m_122245_(minX, minY, maxZ);
                pos3.m_122245_(minX, maxY, maxZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.m_122245_(-1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                pos0.m_122245_(maxX, maxY, maxZ);
                pos1.m_122245_(maxX, minY, maxZ);
                pos2.m_122245_(maxX, minY, minZ);
                pos3.m_122245_(maxX, maxY, minZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.m_122245_(1.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                maxU = 1.0f;
                maxV = 1.0f;
            }
        }
        this.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0.0f, 0.0f, maxU, maxV, lightmap, normal);
    }

    protected void renderBoxEdges(PoseStack ms, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, float lineWidth, Vector4f color, int lightmap, boolean disableNormals) {
        Vector3f origin = this.originTemp;
        PoseStack.Pose pose = ms.m_85850_();
        float lineLengthX = maxPos.m_122239_() - minPos.m_122239_();
        float lineLengthY = maxPos.m_122260_() - minPos.m_122260_();
        float lineLengthZ = maxPos.m_122269_() - minPos.m_122269_();
        origin.m_176768_(minPos);
        this.bufferCuboidLine(pose, consumer, origin, Direction.EAST, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, Direction.UP, lineLengthY, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, Direction.SOUTH, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(maxPos.m_122239_(), minPos.m_122260_(), minPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.UP, lineLengthY, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, Direction.SOUTH, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(minPos.m_122239_(), maxPos.m_122260_(), minPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.EAST, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, Direction.SOUTH, lineLengthZ, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(minPos.m_122239_(), minPos.m_122260_(), maxPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.EAST, lineLengthX, lineWidth, color, lightmap, disableNormals);
        this.bufferCuboidLine(pose, consumer, origin, Direction.UP, lineLengthY, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(minPos.m_122239_(), maxPos.m_122260_(), maxPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.EAST, lineLengthX, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(maxPos.m_122239_(), minPos.m_122260_(), maxPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.UP, lineLengthY, lineWidth, color, lightmap, disableNormals);
        origin.m_122245_(maxPos.m_122239_(), maxPos.m_122260_(), minPos.m_122269_());
        this.bufferCuboidLine(pose, consumer, origin, Direction.SOUTH, lineLengthZ, lineWidth, color, lightmap, disableNormals);
    }
}

