/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderProgressBar;
import com.simibubi.create.foundation.ponder.ui.PonderTagScreen;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.ponder.DebugScenes;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.ScreenUtils;
import net.minecraftforge.registries.ForgeRegistries;

public class PonderUI
extends NavigatableSimiScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final String PONDERING = "ponder.pondering";
    public static final String IDENTIFY_MODE = "ponder.identify_mode";
    public static final String IN_CHAPTER = "ponder.in_chapter";
    public static final String IDENTIFY = "ponder.identify";
    public static final String PREVIOUS = "ponder.previous";
    public static final String CLOSE = "ponder.close";
    public static final String NEXT = "ponder.next";
    public static final String NEXT_UP = "ponder.next_up";
    public static final String REPLAY = "ponder.replay";
    public static final String SLOW_TEXT = "ponder.slow_text";
    private List<PonderScene> scenes;
    private List<PonderTag> tags;
    private List<PonderButton> tagButtons;
    private List<LerpedFloat> tagFades;
    private LerpedFloat fadeIn;
    ItemStack stack;
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private ItemStack hoveredTooltipItem;
    private BlockPos hoveredBlockPos;
    private ClipboardManager clipboardHelper;
    private BlockPos copiedBlockPos;
    private LerpedFloat finishingFlash;
    private LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private LerpedFloat lazyIndex;
    private int index = 0;
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(ResourceLocation id) {
        return new PonderUI(PonderRegistry.compile(id));
    }

    public static PonderUI of(ItemStack item) {
        return new PonderUI(PonderRegistry.compile(RegisteredObjects.getKeyOrThrow(item.m_41720_())));
    }

    public static PonderUI of(ItemStack item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderRegistry.compile(RegisteredObjects.getKeyOrThrow(item.m_41720_())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    public static PonderUI of(PonderChapter chapter) {
        PonderUI ui = new PonderUI(PonderRegistry.compile(chapter));
        ui.chapter = chapter;
        return ui;
    }

    protected PonderUI(List<PonderScene> scenes) {
        ResourceLocation component = scenes.get(0).getComponent();
        this.stack = ForgeRegistries.ITEMS.containsKey(component) ? new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(component)) : new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(component));
        this.tags = new ArrayList<PonderTag>(PonderRegistry.TAGS.getTags(component));
        this.scenes = scenes;
        if (scenes.isEmpty()) {
            List<PonderStoryBoardEntry> l = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "create", "debug/scene_1", new ResourceLocation("minecraft", "stick")));
            scenes.addAll(PonderRegistry.compile(l));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new ClipboardManager();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.m_142416_(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        Options bindings = this.f_96541_.f_91066_;
        int spacing = 8;
        int bX = (this.f_96543_ - 20) / 2 - (70 + 2 * spacing);
        int bY = this.f_96544_ - 20 - 31;
        int pX = this.f_96543_ / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.f_96543_ - 2 * pX;
        this.m_142416_(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.f_92094_)).showing(AllIcons.I_MTD_SCAN)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = this.f_96541_.m_91296_();
            }
        });
        this.m_142416_(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.f_96543_ - 20 - 31, bY).showing(AllIcons.I_MTD_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.m_142416_(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.f_96543_ - 50 - 31, bY).showing(AllIcons.I_MTD_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.m_142416_(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.f_92086_)).showing(AllIcons.I_MTD_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.m_142416_(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.f_92092_)).showing(AllIcons.I_MTD_CLOSE)).enableFade(0, 5)).withCallback(this::m_7379_);
        this.m_142416_(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.f_92088_)).showing(AllIcons.I_MTD_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.m_142416_(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.f_92087_)).showing(AllIcons.I_MTD_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.m_142416_(this.replay);
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(this.stack);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = ItemStack.f_41583_;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        PonderScene.SceneTransform t = activeScene.getTransform();
        Vec3 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        Vec3 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<ItemStack, BlockPos> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.scroll(delta > 0.0)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.m_96638_()) {
            List<PonderStoryBoardEntry> list = PonderRegistry.ALL.get(scene.getComponent());
            PonderStoryBoardEntry sb = list.get(this.index);
            StructureTemplate activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicLocation());
            PonderWorld world = new PonderWorld(BlockPos.f_121853_, (Level)Minecraft.m_91087_().f_91073_);
            activeTemplate.m_230328_((ServerLevelAccessor)world, BlockPos.f_121853_, BlockPos.f_121853_, new StructurePlaceSettings(), RandomSource.m_216327_(), 2);
            world.createBackup();
            scene = PonderRegistry.compileScene(this.index, sb, world);
            scene.begin();
            this.scenes.set(this.index, scene);
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = Mth.m_14045_((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.m_69478_();
        this.renderVisibleScenes(ms, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(ms, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    public void m_7333_(PoseStack ms) {
        super.m_7333_(ms);
    }

    protected void renderVisibleScenes(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderScene(ms, mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(ms, mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(PoseStack ms, int mouseX, int mouseY, int i, float partialTicks) {
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        PonderScene scene = this.scenes.get(i);
        double value = this.lazyIndex.getValue(this.f_96541_.m_91296_());
        double diff = (double)i - value;
        double slide = Mth.m_14139_((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_157183_();
        Matrix4f matrix4f = new Matrix4f(RenderSystem.m_157192_());
        matrix4f.m_162199_(0.0f, 0.0f, 800.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, -800.0);
        scene.getTransform().updateScreenParams(this.f_96543_, this.f_96544_, slide);
        scene.getTransform().apply(ms, partialTicks);
        scene.getTransform().updateSceneRVE(partialTicks);
        scene.renderScene(buffer, ms, partialTicks);
        buffer.draw();
        BoundingBox bounds = scene.getBounds();
        ms.m_85836_();
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            RenderSystem.m_69481_();
            RenderSystem.m_69482_();
            ms.m_85836_();
            ms.m_85837_((double)scene.getBasePlateOffsetX(), 0.0, (double)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(ms);
            float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                ms.m_85837_((double)scene.getBasePlateSize(), 0.0, 0.0);
                ms.m_85836_();
                ms.m_85837_(0.0, 0.0, -9.765625E-4);
                if (flash > 0.0f) {
                    ms.m_85836_();
                    ms.m_85841_(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    ScreenUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)0, (int)0, (int)-1, (int)(-scene.getBasePlateSize()), (int)0, (int)13041609, (int)new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    ms.m_85849_();
                }
                ms.m_85837_(0.0, 0.0, 0.001953125);
                ScreenUtils.drawGradientRect((Matrix4f)ms.m_85850_().m_85861_(), (int)0, (int)0, (int)0, (int)(-scene.getBasePlateSize()), (int)4, (int)0x66000000, (int)0);
                ms.m_85849_();
                ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            }
            ms.m_85849_();
            RenderSystem.m_69464_();
            RenderSystem.m_69465_();
        }
        if (PonderIndex.editingModeActive() && !this.userViewMode) {
            ms.m_85841_(-1.0f, -1.0f, 1.0f);
            ms.m_85841_(0.0625f, 0.0625f, 0.0625f);
            ms.m_85837_(1.0, -8.0, -0.015625);
            ms.m_85836_();
            ms.m_85837_(4.0, -3.0, 0.0);
            ms.m_85837_(0.0, 0.0, -0.001953125);
            for (int x = 0; x <= bounds.m_71056_(); ++x) {
                ms.m_85837_(-16.0, 0.0, 0.0);
                this.f_96547_.m_92883_(ms, (String)(x == bounds.m_71056_() ? "x" : "" + x), 0.0f, 0.0f, -1);
            }
            ms.m_85849_();
            ms.m_85836_();
            ms.m_85841_(-1.0f, 1.0f, 1.0f);
            ms.m_85837_(0.0, -3.0, -4.0);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            ms.m_85837_(-8.0, -2.0, 0.03125);
            for (int z = 0; z <= bounds.m_71058_(); ++z) {
                ms.m_85837_(16.0, 0.0, 0.0);
                this.f_96547_.m_92883_(ms, (String)(z == bounds.m_71058_() ? "z" : "" + z), 0.0f, 0.0f, -1);
            }
            ms.m_85849_();
            ms.m_85836_();
            ms.m_85837_((double)(bounds.m_71056_() * -8), 0.0, (double)(bounds.m_71058_() * 8));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            for (Direction d : Iterate.horizontalDirections) {
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                ms.m_85836_();
                ms.m_85837_(0.0, 0.0, (double)(bounds.m_71058_() * 16));
                ms.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                this.f_96547_.m_92883_(ms, d.name().substring(0, 1), 0.0f, 0.0f, 0x66FFFFFF);
                this.f_96547_.m_92883_(ms, "|", 2.0f, 10.0f, 0x44FFFFFF);
                this.f_96547_.m_92883_(ms, ".", 2.0f, 14.0f, 0x22FFFFFF);
                ms.m_85849_();
            }
            ms.m_85849_();
            buffer.draw();
        }
        ms.m_85849_();
        ms.m_85849_();
        RenderSystem.m_157424_();
    }

    protected void renderWidgets(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69465_();
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = Math.abs(lazyIndexValue - (float)this.index);
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (GuiEventListener child : this.m_6702_()) {
            noWidgetsHovered &= !child.m_5953_((double)mouseX, (double)mouseY);
        }
        int tooltipColor = Theme.i(Theme.Key.TEXT_DARKER);
        this.renderChapterTitle(ms, fade, indexDiff, activeScene, tooltipColor);
        this.renderNavigationMenu(ms);
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.f_96544_ - 80) {
                ms.m_85836_();
                ms.m_85837_((double)mouseX, (double)mouseY, 100.0);
                if (this.hoveredTooltipItem.m_41619_()) {
                    MutableComponent text = Lang.translateDirect(IDENTIFY_MODE, ((MutableComponent)this.f_96541_.f_91066_.f_92094_.m_90863_()).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GRAY);
                    this.renderComponentTooltip(ms, this.f_96547_.m_92865_().m_92414_((FormattedText)text, this.f_96543_ / 3, Style.f_131099_), 0, 0, this.f_96547_);
                } else {
                    this.m_6057_(ms, this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    ms.m_85837_(0.0, -15.0, 0.0);
                    boolean copied = this.copiedBlockPos != null && this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    MutableComponent coords = Components.literal(this.hoveredBlockPos.m_123341_() + ", " + this.hoveredBlockPos.m_123342_() + ", " + this.hoveredBlockPos.m_123343_()).m_130940_(copied ? ChatFormatting.GREEN : ChatFormatting.GOLD);
                    this.m_96602_(ms, (Component)coords, 0, 0);
                }
                ms.m_85849_();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(ms, partialTicks, lazyIndexValue, indexDiff);
        boolean finished = activeScene.isFinished();
        if (finished) {
            this.jumpToNextScene(ms, partialTicks, nextScene);
        }
        this.f_169369_.forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (finished) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        this.renderPonderTags(ms, mouseX, mouseY, partialTicks, fade, activeScene);
        this.renderHoverTooltips(ms, tooltipColor);
        RenderSystem.m_69482_();
    }

    protected void renderPonderTags(PoseStack ms, int mouseX, int mouseY, float partialTicks, float fade, PonderScene activeScene) {
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.contains(PonderTag.HIGHLIGHT_ALL);
        double s = Minecraft.m_91087_().m_91268_().m_85449_();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.m_85836_();
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.m_5953_(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.f_93620_ + button.m_5711_() + 4;
            int y = button.f_93621_ - 2;
            ms.m_85837_((double)x, (double)((float)y + 5.0f * (1.0f - fade)), 800.0);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(ms, 0.0f, 0, 12, 26, (int)fadedWidth);
            RenderSystem.m_69488_((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.f_96544_ * s)));
            String tagName = this.tags.get(i).getTitle();
            this.f_96547_.m_92883_(ms, tagName, 3.0f, 8.0f, Theme.i(Theme.Key.TEXT_ACCENT_SLIGHT));
            RenderSystem.m_69471_();
            ms.m_85849_();
        });
    }

    protected void renderSceneOverlay(PoseStack ms, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 100.0);
        this.renderOverlay(ms, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(ms, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        ms.m_85849_();
    }

    protected void jumpToNextScene(PoseStack ms, float partialTicks, PonderScene nextScene) {
        if (nextScene != null && this.nextUp.getValue() > 0.0625f && !nextScene.getId().equals((Object)Create.asResource("creative_motor_mojang"))) {
            ms.m_85836_();
            ms.m_85837_((double)(this.right.f_93620_ + 10), (double)((float)(this.right.f_93621_ - 6) + this.nextUp.getValue(partialTicks) * 5.0f), 400.0);
            int boxWidth = Math.max(this.f_96547_.m_92895_(nextScene.getTitle()), this.f_96547_.m_92852_((FormattedText)Lang.translateDirect(NEXT_UP, new Object[0]))) + 5;
            PonderUI.renderSpeechBox(ms, 0, 0, boxWidth, 20, this.right.m_198029_(), Pointing.DOWN, false);
            ms.m_85837_(0.0, -29.0, 100.0);
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(NEXT_UP, new Object[0]), (int)0, (int)0, (int)Theme.i(Theme.Key.TEXT_DARKER));
            PonderUI.m_93208_((PoseStack)ms, (Font)this.f_96547_, (String)nextScene.getTitle(), (int)0, (int)10, (int)Theme.i(Theme.Key.TEXT));
            ms.m_85849_();
        }
    }

    protected void renderHoverTooltips(PoseStack ms, int tooltipColor) {
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 500.0);
        int tooltipY = this.f_96544_ - 16;
        if (this.scan.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(IDENTIFY, new Object[0]), (int)(this.scan.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != 0 && this.left.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(PREVIOUS, new Object[0]), (int)(this.left.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.close.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(CLOSE, new Object[0]), (int)(this.close.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(NEXT, new Object[0]), (int)(this.right.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.replay.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(REPLAY, new Object[0]), (int)(this.replay.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        if (this.slowMode.m_198029_()) {
            PonderUI.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)Lang.translateDirect(SLOW_TEXT, new Object[0]), (int)(this.slowMode.f_93620_ + 5), (int)tooltipY, (int)tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.m_198029_()) {
            PonderUI.m_93208_((PoseStack)ms, (Font)this.f_96547_, (String)"Editor View", (int)(this.userMode.f_93620_ + 10), (int)tooltipY, (int)tooltipColor);
        }
        ms.m_85849_();
    }

    protected void renderChapterTitle(PoseStack ms, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 400.0);
        int x = 59;
        int y = 31;
        String title = activeScene.getTitle();
        int wordWrappedHeight = this.f_96547_.m_92920_(title, this.left.f_93620_ - 51);
        int streakHeight = 26 + wordWrappedHeight;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(150.0f * fade));
        UIRenderHelper.streak(ms, 180.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        ((RenderElement)GuiGameElement.of(this.stack).scale(2.0).at((float)x - 39.0f, (float)y - 11.0f)).render(ms);
        this.f_96547_.m_92889_(ms, (Component)Lang.translateDirect(PONDERING, new Object[0]), (float)x, (float)(y - 6), tooltipColor);
        ms.m_85837_((double)(x += 0), (double)(y += 8), 0.0);
        ms.m_85845_(Vector3f.f_122222_.m_122240_(indexDiff * -75.0f));
        ms.m_85837_(0.0, 0.0, 5.0);
        FontHelper.drawSplitString(ms, this.f_96547_, title, 0, 0, this.left.f_93620_ - 51, Theme.c(Theme.Key.TEXT).scaleAlpha(1.0f - indexDiff).getRGB());
        ms.m_85849_();
        if (this.chapter != null) {
            ms.m_85836_();
            ms.m_85837_((double)(this.chap.f_93620_ - 8), (double)this.chap.f_93621_, 0.0);
            UIRenderHelper.streak(ms, 180.0f, 4, 10, 26, (int)(150.0f * fade));
            this.drawRightAlignedString(this.f_96547_, ms, Lang.translateDirect(IN_CHAPTER, new Object[0]).getString(), 0, 0, tooltipColor);
            this.drawRightAlignedString(this.f_96547_, ms, this.chapter.getTitle(), 0, 12, Theme.i(Theme.Key.TEXT));
            ms.m_85849_();
        }
    }

    protected void renderNavigationMenu(PoseStack ms) {
        Color c1 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(64);
        Color c2 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(32);
        Color c3 = Theme.c(Theme.Key.PONDER_BACK_ARROW).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(ms, this.f_96543_ / 2 - 20, this.f_96544_ - 51, 0, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.f_96543_ / 2 + 20, this.f_96544_ - 51, 0, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(ms, this.f_96543_ / 2 - 90, this.f_96544_ - 51, 0, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(ms, this.f_96543_ / 2 + 90, this.f_96544_ - 51, 0, -70, 20, -5, c1, c3);
    }

    private void renderOverlay(PoseStack ms, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        ms.m_85836_();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, ms, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        ms.m_85849_();
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            long handle = this.f_96541_.m_91268_().m_85439_();
            if (this.copiedBlockPos != null && button == 1) {
                this.clipboardHelper.m_83988_(handle, "util.select.fromTo(" + this.copiedBlockPos.m_123341_() + ", " + this.copiedBlockPos.m_123342_() + ", " + this.copiedBlockPos.m_123343_() + ", " + this.hoveredBlockPos.m_123341_() + ", " + this.hoveredBlockPos.m_123342_() + ", " + this.hoveredBlockPos.m_123343_() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (PonderUI.m_96638_()) {
                this.clipboardHelper.m_83988_(handle, "util.select.position(" + this.hoveredBlockPos.m_123341_() + ", " + this.hoveredBlockPos.m_123342_() + ", " + this.hoveredBlockPos.m_123343_() + ")");
            } else {
                this.clipboardHelper.m_83988_(handle, "util.grid.at(" + this.hoveredBlockPos.m_123341_() + ", " + this.hoveredBlockPos.m_123342_() + ", " + this.hoveredBlockPos.m_123343_() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    @Override
    public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        Options settings = Minecraft.m_91087_().f_91066_;
        int sCode = settings.f_92087_.getKey().m_84873_();
        int aCode = settings.f_92086_.getKey().m_84873_();
        int dCode = settings.f_92088_.getKey().m_84873_();
        int qCode = settings.f_92094_.getKey().m_84873_();
        if (code == sCode) {
            this.replay();
            return true;
        }
        if (code == aCode) {
            this.scroll(false);
            return true;
        }
        if (code == dCode) {
            this.scroll(true);
            return true;
        }
        if (code == qCode) {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            }
            return true;
        }
        return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.m_41720_().m_41466_().getString();
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(PoseStack ms, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        if (!returnWithLocalTransform) {
            ms.m_85836_();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = Theme.p(highlighted ? Theme.Key.PONDER_BUTTON_HOVER : Theme.Key.PONDER_IDLE);
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(borderColors)).at(boxX, boxY, 100.0f)).withBounds(w, h)).render(ms);
        ms.m_85836_();
        ms.m_85837_((double)(divotX + divotRadius), (double)(divotY + divotRadius), 10.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_((float)divotRotation));
        ms.m_85837_((double)(-divotRadius), (double)(-divotRadius), 0.0);
        AllGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(ms, 0, 0);
        AllGuiTextures.SPEECH_TOOLTIP_COLOR.render(ms, 0, 0, c);
        ms.m_85849_();
        if (returnWithLocalTransform) {
            ms.m_85837_((double)boxX, (double)boxY, 0.0);
            return;
        }
        ms.m_85849_();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public ItemStack getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            return this.stack.m_41656_(((PonderUI)other).stack);
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = Minecraft.m_91087_().m_91296_();
        if (Minecraft.m_91087_().f_91080_ instanceof PonderUI) {
            PonderUI ui = (PonderUI)Minecraft.m_91087_().f_91080_;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void m_7861_() {
        super.m_7861_();
        this.hoveredTooltipItem = ItemStack.f_41583_;
    }

    public void drawRightAlignedString(Font fontRenderer, PoseStack ms, String string, int x, int y, int color) {
        fontRenderer.m_92883_(ms, string, (float)(x - fontRenderer.m_92895_(string)), (float)y, color);
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)AllConfigs.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        AllConfigs.client().comfyReading.set(slowTextMode);
    }
}

