/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockTagIngredient
extends AbstractIngredient {
    protected final TagKey<Block> tag;
    @Nullable
    protected ItemStack[] f_43903_;
    @Nullable
    protected IntList f_43904_;

    protected BlockTagIngredient(TagKey<Block> tag) {
        this.tag = tag;
    }

    public static BlockTagIngredient create(TagKey<Block> tag) {
        return new BlockTagIngredient(tag);
    }

    protected void m_43948_() {
        if (this.f_43903_ == null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Block block : ForgeRegistries.BLOCKS.tags().getTag(this.tag)) {
                ItemStack stack = new ItemStack((ItemLike)block);
                if (stack.m_41619_()) continue;
                list.add(stack);
            }
            this.f_43903_ = (ItemStack[])list.toArray(ItemStack[]::new);
        }
    }

    public ItemStack[] m_43908_() {
        this.m_43948_();
        return this.f_43903_;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.m_43948_();
        if (this.f_43903_.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemStack : this.f_43903_) {
            if (!itemStack.m_150930_(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public IntList m_43931_() {
        if (this.f_43904_ == null || this.checkInvalidation()) {
            this.markValid();
            this.m_43948_();
            this.f_43904_ = new IntArrayList(this.f_43903_.length);
            for (ItemStack stack : this.f_43903_) {
                this.f_43904_.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.f_43904_.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.f_43904_;
    }

    public TagKey<Block> getTag() {
        return this.tag;
    }

    protected void invalidate() {
        this.f_43903_ = null;
        this.f_43904_ = null;
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("tag", this.tag.f_203868_().toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<BlockTagIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public BlockTagIngredient parse(JsonObject json) {
            ResourceLocation rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)rl);
            return new BlockTagIngredient((TagKey<Block>)tag);
        }

        public BlockTagIngredient parse(FriendlyByteBuf buffer) {
            ResourceLocation rl = buffer.m_130281_();
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)rl);
            return new BlockTagIngredient((TagKey<Block>)tag);
        }

        public void write(FriendlyByteBuf buffer, BlockTagIngredient ingredient) {
            TagKey<Block> tag = ingredient.getTag();
            buffer.m_130085_(tag.f_203868_());
        }
    }
}

