/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileRenderer;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlockEntity;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerRenderer;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonRenderer;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseRenderer;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadRenderer;
import se.mickelus.tetra.blocks.geode.particle.SparkleParticle;
import se.mickelus.tetra.blocks.geode.particle.SparkleParticleType;
import se.mickelus.tetra.blocks.holo.HolosphereEntityRenderer;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicGui;
import se.mickelus.tetra.blocks.scroll.ScrollRenderer;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTESR;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchScreen;
import se.mickelus.tetra.client.keymap.TetraKeyMappings;
import se.mickelus.tetra.client.model.ModularModelLoader;
import se.mickelus.tetra.compat.botania.BotaniaCompat;
import se.mickelus.tetra.effect.gui.AbilityOverlays;
import se.mickelus.tetra.effect.howling.HowlingOverlay;
import se.mickelus.tetra.interactions.SecondaryInteractionOverlay;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.ThrownModularItemRenderer;
import se.mickelus.tetra.items.modular.impl.BlockProgressOverlay;
import se.mickelus.tetra.items.modular.impl.bow.RangedProgressOverlay;
import se.mickelus.tetra.items.modular.impl.crossbow.CrossbowOverlay;
import se.mickelus.tetra.items.modular.impl.holo.gui.scan.ScannerOverlayGui;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldBannerModel;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldModel;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldRenderer;
import se.mickelus.tetra.items.modular.impl.toolbelt.booster.OverlayBooster;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay.ToolbeltOverlay;

public class ClientSetup {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ClientSetup.class);
        MinecraftForge.EVENT_BUS.register(ClientSetup.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                MenuScreens.m_96206_((MenuType)((MenuType)WorkbenchContainer.containerType.get()), WorkbenchScreen::new);
                BotaniaCompat.clientInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void provideTextures(TextureStitchEvent.Pre event) {
        if (TextureAtlas.f_118259_.equals((Object)event.getAtlas().m_118330_())) {
            Minecraft.m_91087_().m_91098_().m_214159_("textures/items/module", rl -> rl.m_135815_().endsWith(".png")).keySet().stream().filter(rl -> "tetra".equals(rl.m_135827_())).map(rl -> new ResourceLocation(rl.m_135827_(), rl.m_135815_().substring(9, rl.m_135815_().length() - 4))).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            event.addSprite(ForgedContainerRenderer.material.m_119203_());
            event.addSprite(HammerBaseRenderer.material.m_119203_());
            event.addSprite(ScrollRenderer.material.m_119203_());
            event.addSprite(HolosphereEntityRenderer.material.m_119203_());
        }
    }

    @SubscribeEvent
    public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)SparkleParticleType.instance, SparkleParticle.Provider::new);
    }

    @SubscribeEvent
    public static void modelRegistryReady(ModelEvent.RegisterGeometryLoaders event) {
        event.register("modular_loader", (IGeometryLoader)new ModularModelLoader());
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ForgedContainerRenderer.layer, ForgedContainerRenderer::createLayer);
        event.registerLayerDefinition(HammerBaseRenderer.layer, HammerBaseRenderer::createLayer);
        event.registerLayerDefinition(ScrollRenderer.layer, ScrollRenderer::createLayer);
        event.registerLayerDefinition(ModularShieldRenderer.layer, ModularShieldModel::createLayer);
        event.registerLayerDefinition(ModularShieldRenderer.bannerLayer, ModularShieldBannerModel::createLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ExtractorProjectileEntity.type, ExtractorProjectileRenderer::new);
        event.registerEntityRenderer(ThrownModularItemEntity.type, ThrownModularItemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)WorkbenchTile.type.get(), WorkbenchTESR::new);
        event.registerBlockEntityRenderer(ScrollTile.type, ScrollRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ForgedContainerBlockEntity.type.get(), ForgedContainerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CoreExtractorPistonBlockEntity.type.get(), CoreExtractorPistonRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)HammerBaseBlockEntity.type.get(), HammerBaseRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)HammerHeadBlockEntity.type.get(), HammerHeadRenderer::new);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ClientSetup.registerOverlay(event, "howling", new HowlingOverlay(mc));
        ClientSetup.registerOverlay(event, "ability_overlays", new AbilityOverlays(mc));
        ClientSetup.registerOverlay(event, "toolbelt", new ToolbeltOverlay(mc));
        ClientSetup.registerOverlay(event, "secondary_interaction", new SecondaryInteractionOverlay(mc));
        ClientSetup.registerOverlay(event, "booster", new OverlayBooster(mc));
        ClientSetup.registerOverlay(event, "block_progresss", new BlockProgressOverlay(mc));
        ClientSetup.registerOverlay(event, "ranged_progresss", new RangedProgressOverlay(mc));
        ClientSetup.registerOverlay(event, "crossbow", new CrossbowOverlay(mc));
        ClientSetup.registerOverlay(event, "scanner", new ScannerOverlayGui());
        ClientSetup.registerOverlay(event, "multiblock_schematic", new MultiblockSchematicGui(mc));
    }

    private static void registerOverlay(RegisterGuiOverlaysEvent event, String id, IGuiOverlay overlay) {
        event.registerBelowAll(id, overlay);
        MinecraftForge.EVENT_BUS.register((Object)overlay);
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(TetraKeyMappings.accessBinding);
        event.register(TetraKeyMappings.restockBinding);
        event.register(TetraKeyMappings.openBinding);
        event.register(TetraKeyMappings.secondaryUseBinding);
    }
}

