/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class PropertyMatcher
implements Predicate<BlockState> {
    public static final PropertyMatcher any = new PropertyMatcher();
    private final Map<Property<?>, Predicate<?>> propertyPredicates = Maps.newHashMap();
    private Block block = null;

    public static PropertyMatcher deserialize(JsonElement json) {
        PropertyMatcher result = new PropertyMatcher();
        if (json.isJsonObject()) {
            ResourceLocation resourceLocation;
            String blockString;
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"propertyMatcher");
            if (jsonObject.has("block") && (blockString = jsonObject.get("block").getAsString()) != null && ForgeRegistries.BLOCKS.containsKey(resourceLocation = new ResourceLocation(blockString))) {
                result.block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            }
            if (result.block != null && jsonObject.has("state")) {
                StateDefinition stateContainer = result.block.m_49965_();
                for (Map.Entry entry : jsonObject.get("state").getAsJsonObject().entrySet()) {
                    Property property = stateContainer.m_61081_((String)entry.getKey());
                    if (property == null) {
                        throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + result.block.m_7705_() + "'");
                    }
                    String s = GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                    Optional optional = property.m_6215_(s);
                    if (!optional.isPresent()) {
                        throw new JsonSyntaxException("Invalid block state value '" + s + "' for property '" + (String)entry.getKey() + "' on block '" + result.block.m_7705_() + "'");
                    }
                    result.propertyPredicates.put((Property<?>)property, (Predicate<?>)Predicates.equalTo(optional.get()));
                }
            }
        } else {
            ResourceLocation resourceLocation;
            String blockString = json.getAsString();
            if (blockString != null && ForgeRegistries.BLOCKS.containsKey(resourceLocation = new ResourceLocation(blockString))) {
                result.block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            }
        }
        return result;
    }

    @Override
    public boolean test(BlockState blockState) {
        if (this.block != null && this.block != blockState.m_60734_()) {
            return false;
        }
        for (Map.Entry<Property<?>, Predicate<?>> entry : this.propertyPredicates.entrySet()) {
            if (this.matches(blockState, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean matches(BlockState blockState, Property<T> property, Predicate<T> predicate) {
        return predicate.test(blockState.m_61143_(property));
    }

    public <V extends Comparable<V>> PropertyMatcher where(Property<V> property, Predicate<? extends V> is) {
        this.propertyPredicates.put(property, is);
        return this;
    }
}

