/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.multischematic;

import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.blocks.ISchematicProviderBlock;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicBlock;
import se.mickelus.tetra.blocks.multischematic.RuinedMultiblockSchematicBlock;

public class PrimaryMultiblockSchematicBlock
extends MultiblockSchematicBlock
implements ISchematicProviderBlock {
    public static final BooleanProperty complete = BooleanProperty.m_61465_((String)"complete");
    protected final ResourceLocation[] schematics;

    public PrimaryMultiblockSchematicBlock(BlockBehaviour.Properties properties, String schematic, RegistryObject<RuinedMultiblockSchematicBlock> ruinedRef, ResourceLocation pryTable, int x, int y, int height, int width) {
        super(properties, schematic, ruinedRef, pryTable, x, y, height, width);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)facingProp, (Comparable)Direction.EAST)).m_61124_((Property)complete, (Comparable)Boolean.valueOf(false)));
        this.schematics = new ResourceLocation[]{new ResourceLocation("tetra", schematic)};
    }

    @Override
    public boolean canUnlockSchematics(Level world, BlockPos pos, BlockPos targetPos) {
        return (Boolean)world.m_8055_(pos).m_61143_((Property)complete);
    }

    @Override
    public ResourceLocation[] getSchematics(Level world, BlockPos pos, BlockState blockState) {
        return this.schematics;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{complete});
    }

    public void updateComplete(BlockState blockState, LevelAccessor level, BlockPos worldPos, BlockPos placePos) {
        boolean isComplete = this.getSchematicParts(blockState, level, worldPos).filter(part -> part.blockState().m_60734_() instanceof MultiblockSchematicBlock).filter(part -> this.isCorrectPart(part.basePos(), (MultiblockSchematicBlock)part.blockState().m_60734_())).count() == (long)(this.width * this.height);
        level.m_7731_(worldPos, (BlockState)blockState.m_61124_((Property)complete, (Comparable)Boolean.valueOf(isComplete)), 3);
        if (isComplete) {
            this.spawnCompleteParticle(blockState, (ServerLevel)level, worldPos, placePos);
        }
    }

    protected void spawnCompleteParticle(BlockState blockState, ServerLevel level, BlockPos worldPos, BlockPos placePos) {
        Vec3 pPos;
        Direction facing = (Direction)blockState.m_61143_((Property)facingProp);
        Vec3 face = Vec3.m_82528_((Vec3i)facing.m_122436_());
        Vec3 dir = Vec3.m_82528_((Vec3i)facing.m_122428_().m_122436_());
        Vec3 placeVec = Vec3.m_82512_((Vec3i)placePos);
        Vec3 origin = Vec3.m_82539_((Vec3i)RotationHelper.rotateDirection((BlockPos)new BlockPos(-this.x, -this.y, 0), (Direction)facing).m_121955_((Vec3i)worldPos)).m_82549_(face.m_82490_(0.52)).m_82549_(dir.m_82490_(-0.5));
        float x = 0.0f;
        while (x < (float)this.width) {
            pPos = origin.m_82549_(dir.m_82490_((double)x)).m_82520_(0.0, Math.sin((double)(System.currentTimeMillis() + 5L) + (double)this.y * 2.3) * 0.1, 0.0);
            this.spawnParticle(level, pPos, this.getDelay(pPos, placeVec));
            x = (float)((double)x + 0.333333333);
        }
        x = 0.0f;
        while (x < (float)this.width) {
            pPos = origin.m_82549_(dir.m_82490_((double)x)).m_82520_(0.0, (double)this.height + Math.sin((double)(System.currentTimeMillis() + 2L) + (double)this.y * 2.56) * 0.1, 0.0);
            this.spawnParticle(level, pPos, this.getDelay(pPos, placeVec));
            x = (float)((double)x + 0.333333333);
        }
        float y = 0.0f;
        while (y < (float)this.height) {
            pPos = origin.m_82520_(0.0, (double)y, 0.0).m_82549_(dir.m_82490_(Math.sin((double)(System.currentTimeMillis() + 2L) + (double)y * 2.56) * 0.1));
            this.spawnParticle(level, pPos, this.getDelay(pPos, placeVec));
            y = (float)((double)y + 0.333333333);
        }
        y = 0.0f;
        while (y < (float)this.height) {
            pPos = origin.m_82520_(0.0, (double)y, 0.0).m_82549_(dir.m_82490_((double)this.width + Math.sin((double)(System.currentTimeMillis() + 5L) + (double)y * 2.3) * 0.1));
            this.spawnParticle(level, pPos, this.getDelay(pPos, placeVec));
            y = (float)((double)y + 0.333333333);
        }
    }

    private void spawnParticle(ServerLevel level, Vec3 pos, int delay) {
        ServerScheduler.schedule(delay, () -> level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 0.9f, 0.5f), 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 1.0));
    }

    private int getDelay(Vec3 a, Vec3 b) {
        return 2 * (this.width + this.height) + Math.max((int)(3.0 * ((double)(this.width + this.height) - (Math.abs(a.f_82479_ - b.f_82479_) + Math.abs(a.f_82480_ - b.f_82480_) + Math.abs(a.f_82481_ - b.f_82481_)))), 0);
    }

    protected boolean isCorrectPart(BlockPos basePos, MultiblockSchematicBlock block) {
        return this.schematic.equals(block.schematic) && block.x == basePos.m_123341_() && block.y == basePos.m_123342_();
    }

    @Override
    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldBlock, boolean p_60570_) {
        if (!this.equals(oldBlock.m_60734_())) {
            this.updateComplete(blockState, (LevelAccessor)level, blockPos, blockPos);
        }
    }
}

