/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.compat.botania;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.compat.botania.ManaRepairStatGetter;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import vazkii.botania.api.mana.ManaItemHandler;

@ParametersAreNonnullByDefault
public class ManaRepair {
    public static ItemEffect effect = ItemEffect.get("manaRepair");

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        ManaRepairStatGetter statGetter = new ManaRepairStatGetter();
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.manaRepair", 0.0, 400.0, false, false, true, statGetter, LabelGetterBasic.integerLabelInverted, new TooltipGetterInteger("tetra.stats.manaRepair.tooltip", statGetter));
        WorkbenchStatsGui.addBar(statBar);
        HoloStatsGui.addBar(statBar);
    }

    public static void itemInventoryTick(ItemStack itemStack, Level world, Entity entity) {
        int damage;
        Player player;
        int repairAmount;
        float durabilityPerMana;
        if (!world.f_46443_ && world.m_46467_() % 20L == 0L && (durabilityPerMana = EffectHelper.getEffectEfficiency(itemStack, effect)) > 0.0f && itemStack.m_41773_() > 0 && entity instanceof Player && (repairAmount = ManaRepair.requestManaForDurability(player = (Player)entity, itemStack, damage = itemStack.m_41773_(), durabilityPerMana)) > 0) {
            itemStack.m_41721_(damage - repairAmount);
        }
    }

    public static int reduceDurabilityDamage(Level level, Entity entity, ItemStack itemStack, int amount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float durabilityPerMana = EffectHelper.getEffectEfficiency(itemStack, effect);
            if (durabilityPerMana > 0.0f) {
                int result = ManaRepair.requestManaForDurability(player, itemStack, amount, durabilityPerMana);
                return amount - result;
            }
        }
        return amount;
    }

    private static int requestManaForDurability(Player player, ItemStack itemStack, int damage, float durabilityPerMana) {
        int grantedMana = ManaItemHandler.instance().requestManaForTool(itemStack, player, Mth.m_14167_((float)((float)damage / durabilityPerMana)), true);
        return Math.min((int)(durabilityPerMana * (float)grantedMana), damage);
    }
}

