/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;

public class FocusEffect {
    private static final Cache<Integer, Integer> cache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.f_19853_.m_46467_() % 2L == 0L) {
            if (FocusEffect.hasApplicableItem((LivingEntity)event.player) && event.player.m_6047_()) {
                Player player = event.player;
                int id = FocusEffect.getIdentifier(player);
                Integer duration = (Integer)cache.getIfPresent((Object)id);
                boolean isDrawing = FocusEffect.isDrawing(event.player);
                int change = isDrawing ? 1 : 2;
                cache.put((Object)id, (Object)(duration != null ? duration + change : change));
                if (!player.f_19853_.f_46443_) {
                    int respiration = EnchantmentHelper.m_44918_((LivingEntity)player);
                    int amount = isDrawing ? 6 : 2;
                    int reduction = 0;
                    if (respiration > 0) {
                        for (int i = 0; i < amount - 1; ++i) {
                            if (player.m_217043_().m_188503_(respiration + 2) <= 1) continue;
                            ++reduction;
                        }
                    }
                    player.m_20301_(player.m_20146_() - (amount - reduction));
                    if (player.m_20146_() <= -20) {
                        player.m_20301_(0);
                        player.m_6469_(DamageSource.f_19312_, 2.0f);
                    }
                }
            } else {
                cache.invalidate((Object)FocusEffect.getIdentifier(event.player));
            }
        }
    }

    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (event.getAmount() > 0.0f && event.getSource() != DamageSource.f_19312_ && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            cache.invalidate((Object)FocusEffect.getIdentifier(player));
        }
    }

    public static void onFireArrow(Player player, ItemStack itemStack) {
        boolean hasEcho = CastOptional.cast((Object)itemStack.m_41720_(), ModularItem.class).filter(item -> item.getEffectLevel(itemStack, ItemEffect.focusEcho) > 0).isPresent();
        if (!hasEcho) {
            cache.invalidate((Object)FocusEffect.getIdentifier(player));
        }
    }

    public static boolean isDrawing(Player player) {
        ItemStack itemStack = player.m_21211_();
        return CastOptional.cast((Object)itemStack.m_41720_(), ModularBowItem.class).map(item -> item.getProgress(itemStack, (LivingEntity)player) < 1.0f).orElse(false);
    }

    public static float getSpreadReduction(Player player, ItemStack itemStack) {
        Integer duration = (Integer)cache.getIfPresent((Object)FocusEffect.getIdentifier(player));
        if (duration != null) {
            return CastOptional.cast((Object)itemStack.m_41720_(), ModularItem.class).map(item -> Float.valueOf(item.getEffectEfficiency(itemStack, ItemEffect.focus) * (float)duration.intValue() / 20.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public static boolean hasApplicableItem(LivingEntity player) {
        return FocusEffect.isApplicableItem(player.m_21205_()) || FocusEffect.isApplicableItem(player.m_21206_());
    }

    public static boolean isApplicableItem(ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), ModularItem.class).filter(item -> item.getEffectEfficiency(itemStack, ItemEffect.focus) > 0.0f).isPresent();
    }

    private static int getIdentifier(Player entity) {
        return entity.f_19853_.f_46443_ ? -entity.m_19879_() : entity.m_19879_();
    }
}

