/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class ReachingEffect {
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getPosition().isPresent()) {
            Optional.of(event.getEntity().m_21205_()).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> itemStack.m_41720_() instanceof ItemModularHandheld).ifPresent(itemStack -> {
                double distance;
                int level = EffectHelper.getEffectLevel(itemStack, ItemEffect.reaching);
                if (level > 0 && (distance = event.getEntity().m_20182_().m_82557_(Vec3.m_82512_((Vec3i)((Vec3i)event.getPosition().get())))) > 1.0) {
                    event.setNewSpeed(event.getNewSpeed() * ReachingEffect.getMultiplier(level, distance, 1.0f));
                }
            });
        }
    }

    public static void onLivingDamage(LivingDamageEvent event, int level, float efficiency) {
        float multiplier;
        double distance = event.getSource().m_7639_().m_20280_((Entity)event.getEntity());
        float f = multiplier = event.getSource() instanceof IndirectEntityDamageSource ? efficiency : 1.0f;
        if (distance > 1.0) {
            event.setAmount(event.getAmount() * ReachingEffect.getMultiplier(level, distance, multiplier));
        }
    }

    public static float getMultiplier(int level, double squareDistance, float offsetMultiplier) {
        return level > 0 ? 1.0f + ReachingEffect.getOffset(level, squareDistance) * offsetMultiplier : 0.0f;
    }

    public static float getOffset(int level, double squareDistance) {
        return level > 0 ? (float)((double)((float)level / 100.0f) * Math.log(squareDistance * squareDistance)) : 0.0f;
    }
}

