/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SculkSpreader;
import se.mickelus.tetra.ServerScheduler;

public class SculkTaintEffect {
    public static void perform(ServerLevel level, BlockPos target, int effectLevel, float effectEfficiency) {
        if (level.m_213780_().m_188500_() * 100.0 < (double)effectEfficiency) {
            SculkTaintEffect.startSpread(level, target, effectLevel);
        }
    }

    public static void startSpread(ServerLevel level, BlockPos target, int severity) {
        level.m_5594_(null, target, SoundEvents.f_215740_, SoundSource.PLAYERS, 2.0f, 0.6f + level.m_213780_().m_188501_() * 0.4f);
        SculkSpreader spreader = SculkSpreader.m_222254_();
        spreader.m_222266_(target, severity);
        ServerScheduler.schedule(level.m_213780_().m_188503_(3), () -> SculkTaintEffect.tickSpread(spreader, (LevelAccessor)level, target, severity * 10));
    }

    public static void tickSpread(SculkSpreader spreader, LevelAccessor level, BlockPos origin, int bailoutCounter) {
        spreader.m_222255_(level, origin, level.m_213780_(), true);
        if (bailoutCounter > 0 && spreader.m_222283_().size() > 0) {
            ServerScheduler.schedule(level.m_213780_().m_188503_(3), () -> SculkTaintEffect.tickSpread(spreader, level, origin, bailoutCounter - 1));
        } else {
            System.out.println("Bailed on spreader, bailout: " + bailoutCounter + ", cursors: " + spreader.m_222283_().size());
        }
    }
}

