/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.howling;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import se.mickelus.mutil.effect.EffectTooltipRenderer;

@ParametersAreNonnullByDefault
public class HowlingPotionEffect
extends MobEffect {
    public static final String identifier = "howling";
    public static HowlingPotionEffect instance;

    public HowlingPotionEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xEEEEEE);
        this.m_19472_(Attributes.f_22279_, "f80b9432-480d-4846-b9f9-178157dbac07", -0.05, AttributeModifier.Operation.MULTIPLY_BASE);
        instance = this;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity.f_19853_.f_46443_) {
            double offset = Math.PI * 4 / (double)(amplifier + 1);
            for (int i = 0; i < (amplifier + 1) / 2; ++i) {
                double time = (double)System.currentTimeMillis() / 1000.0 * Math.PI + offset * (double)i;
                double xOffset = -Math.cos(time);
                double zOffset = Math.sin(time);
                Vec3 pos = entity.m_20182_().m_82520_(xOffset, 0.1 + Math.random() * (double)entity.m_20206_(), zOffset);
                entity.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, -Math.cos(time - 1.5707963267948966) * 0.1, 0.01, Math.sin(time - 1.5707963267948966) * 0.1);
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientMobEffectExtensions)new EffectTooltipRenderer(effect -> {
            int amp = effect.m_19564_() + 1;
            return I18n.m_118938_((String)"effect.tetra.howling.tooltip", (Object[])new Object[]{String.format("%d", amp * -5), String.format("%.01f", Math.min((double)amp * 12.5, 100.0)), String.format("%.01f", (double)amp * 2.5)});
        }));
    }
}

