/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.potion;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import se.mickelus.mutil.effect.EffectTooltipRenderer;

@ParametersAreNonnullByDefault
public class ExhaustedPotionEffect
extends MobEffect {
    public static final String identifier = "exhausted";
    public static ExhaustedPotionEffect instance;

    public ExhaustedPotionEffect() {
        super(MobEffectCategory.HARMFUL, 0x222222);
        this.m_19472_(Attributes.f_22279_, "19be7b9d-fff9-4ccf-a811-0a378da5a269", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22283_, "05b3352c-4c10-4c52-92ce-9dc8a679e7f0", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
        instance = this;
    }

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().m_21023_((MobEffect)instance)) {
            float multiplier = 1.0f - (float)(event.getEntity().m_21124_((MobEffect)instance).m_19564_() + 1) * 0.05f;
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientMobEffectExtensions)new EffectTooltipRenderer(effect -> {
            int amount = effect.m_19564_() + 1;
            return I18n.m_118938_((String)"effect.tetra.exhausted.tooltip", (Object[])new Object[]{amount * 10, amount * 5});
        }));
    }
}

