/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.potion;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import se.mickelus.mutil.effect.EffectTooltipRenderer;

@ParametersAreNonnullByDefault
public class PuncturedPotionEffect
extends MobEffect {
    public static final String identifier = "punctured";
    public static PuncturedPotionEffect instance;

    public PuncturedPotionEffect() {
        super(MobEffectCategory.HARMFUL, 0x880000);
        this.m_19472_(Attributes.f_22284_, "69967662-e7e9-4671-8f48-81d0de9d2098", -0.05, AttributeModifier.Operation.MULTIPLY_TOTAL);
        instance = this;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!entity.m_20193_().f_46443_) {
            RandomSource rand = entity.m_217043_();
            EquipmentSlot slot = EquipmentSlot.values()[2 + rand.m_188503_(4)];
            ItemStack itemStack = entity.m_6844_(slot);
            if (!itemStack.m_41619_()) {
                ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), entity.m_20185_() + (double)entity.m_20205_() * (0.3 + rand.m_188583_() * 0.4), entity.m_20186_() + (double)entity.m_20206_() * (0.2 + rand.m_188583_() * 0.4), entity.m_20189_() + (double)entity.m_20205_() * (0.3 + rand.m_188583_() * 0.4), 10, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientMobEffectExtensions)new EffectTooltipRenderer(effect -> {
            int amp = effect.m_19564_() + 1;
            double armor = Minecraft.m_91087_().f_91074_.m_21230_();
            double armorReduction = armor / (1.0 - (double)amp * 0.1) - armor;
            return I18n.m_118938_((String)"effect.tetra.punctured.tooltip", (Object[])new Object[]{String.format("%d", amp * 10), String.format("%.1f", armorReduction)});
        }));
    }
}

