/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import se.mickelus.mutil.gui.GuiAlignment;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.tetra.gui.stats.bar.GuiBar;

@ParametersAreNonnullByDefault
public class GuiBarSplit
extends GuiBar {
    private final GuiBar negativeBar;
    private final GuiBar positiveBar;

    public GuiBarSplit(int x, int y, int barLength, double range, boolean inverted) {
        super(x, y, barLength, -range, range, inverted);
        this.negativeBar = new GuiBar(0, 0, (barLength - 5) / 2, 0.0, range, !inverted);
        this.negativeBar.setAlignment(GuiAlignment.right);
        this.addChild(this.negativeBar);
        this.positiveBar = new GuiBar(0, 0, (barLength - 5) / 2, 0.0, range, inverted);
        this.positiveBar.setAttachment(GuiAttachment.topRight);
        this.addChild(this.positiveBar);
        GuiRect separator = new GuiRect(0, 5, 1, 3, 0x7F7F7F);
        separator.setAttachment(GuiAttachment.topCenter);
        this.addChild((GuiElement)separator);
    }

    @Override
    protected void calculateBarLengths() {
        this.negativeBar.setValue(this.value > 0.0 ? 0.0 : -this.value, this.diffValue > 0.0 ? 0.0 : -this.diffValue);
        this.positiveBar.setValue(this.value < 0.0 ? 0.0 : this.value, this.diffValue < 0.0 ? 0.0 : this.diffValue);
    }

    @Override
    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        this.drawChildren(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
    }
}

