/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

@ParametersAreNonnullByDefault
public class GuiStatIndicator
extends GuiTexture {
    protected String label;
    protected IStatGetter statGetter;
    protected ITooltipGetter tooltipGetter;

    public GuiStatIndicator(int x, int y, String label, int textureIndex, IStatGetter statGetter, ITooltipGetter tooltipGetter) {
        super(x, y, 7, 7, textureIndex * 7, 144, GuiTextures.workbench);
        this.label = label;
        this.statGetter = statGetter;
        this.tooltipGetter = tooltipGetter;
    }

    public boolean update(Player player, ItemStack currentStack, ItemStack previewStack, @Nullable String slot, @Nullable String improvement) {
        if (this.statGetter.shouldShow(player, currentStack, previewStack)) {
            double diffValue;
            double value;
            if (!previewStack.m_41619_()) {
                value = this.statGetter.getValue(player, currentStack);
                diffValue = this.statGetter.getValue(player, previewStack);
            } else {
                value = this.statGetter.getValue(player, currentStack);
                if (slot != null) {
                    diffValue = value;
                    value = improvement != null ? (value -= this.statGetter.getValue(player, currentStack, slot, improvement)) : (value -= this.statGetter.getValue(player, currentStack, slot));
                } else {
                    diffValue = value;
                }
            }
            double baseValue = this.statGetter.getValue(player, ItemStack.f_41583_);
            this.setColor(this.getDiffColor(baseValue, value, diffValue));
            return true;
        }
        return false;
    }

    public boolean isActive(Player player, ItemStack itemStack) {
        return this.statGetter.shouldShow(player, itemStack, itemStack);
    }

    protected int getDiffColor(double baseValue, double value, double diffValue) {
        if (diffValue > baseValue && value <= baseValue) {
            return 0x55FF55;
        }
        if (diffValue <= baseValue && value > baseValue) {
            return 0xFF5555;
        }
        if (diffValue == value) {
            return 0xFFFFFF;
        }
        return 0xAAAAFF;
    }

    public String getLabel() {
        return I18n.m_118938_((String)this.label, (Object[])new Object[0]);
    }

    public String getTooltipBase(Player player, ItemStack itemStack) {
        return this.tooltipGetter.getTooltipBase(player, itemStack);
    }

    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return this.tooltipGetter.hasExtendedTooltip(player, itemStack);
    }

    public String getTooltipExtension(Player player, ItemStack itemStack) {
        return this.tooltipGetter.getTooltipExtension(player, itemStack);
    }
}

