/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.properties.AttributeHelper;

@ParametersAreNonnullByDefault
public class ModularDoubleHeadedItem
extends ItemModularHandheld {
    public static final String headLeftKey = "double/head_left";
    public static final String headRightKey = "double/head_right";
    public static final String handleKey = "double/handle";
    public static final String bindingKey = "double/binding";
    public static final String accessoryKey = "double/accessory";
    public static final String leftSuffix = "_left";
    public static final String rightSuffix = "_right";
    public static final String identifier = "modular_double";
    private static final Logger logger = LogManager.getLogger();
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-13, -1, 3, 19, -13, 19);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(6, 1);
    @ObjectHolder(registryName="item", value="tetra:modular_double")
    public static ModularDoubleHeadedItem instance;

    public ModularDoubleHeadedItem() {
        super(new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41486_());
        this.entityHitDamage = 2;
        this.majorModuleKeys = new String[]{headLeftKey, headRightKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headLeftKey, headRightKey};
        this.updateConfig((Integer)ConfigHandler.honedoubleBase.get(), (Integer)ConfigHandler.honedoubleIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this, identifier));
        RemoveSchematic.registerRemoveSchematics(this, identifier);
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("double/");
        });
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.setupHammerStack("oak", "stick"));
            items.add((Object)this.setupHammerStack("stone", "stick"));
            items.add((Object)this.setupHammerStack("iron", "spruce"));
            items.add((Object)this.setupHammerStack("blackstone", "spruce"));
            items.add((Object)this.setupHammerStack("obsidian", "iron"));
            items.add((Object)this.setupHammerStack("netherite", "forged_beam"));
        }
    }

    private ItemStack setupHammerStack(String headMaterial, String handleMaterial) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IModularItem.putModuleInSlot(itemStack, headLeftKey, "double/basic_hammer_left", "double/basic_hammer_left_material", "basic_hammer/" + headMaterial);
        IModularItem.putModuleInSlot(itemStack, headRightKey, "double/basic_hammer_right", "double/basic_hammer_right_material", "basic_hammer/" + headMaterial);
        IModularItem.putModuleInSlot(itemStack, handleKey, "double/basic_handle", "double/basic_handle_material", "basic_handle/" + handleMaterial);
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        if (player != null && !player.m_6047_() && world.m_8055_(pos).m_60734_().equals(Blocks.f_50091_) && this.getToolLevel(player.m_21120_(hand), TetraToolActions.hammer) > 0) {
            return BasicWorkbenchBlock.upgradeWorkbench(player, world, pos, hand, context.m_43719_());
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public String getDisplayNamePrefixes(ItemStack itemStack) {
        return Stream.concat(Arrays.stream(this.getImprovements(itemStack)).map(improvement -> Pair.of((Object)((Object)improvement.prefixPriority), (Object)("tetra.improvement." + improvement.key + ".prefix"))).filter(pair -> I18n.m_118936_((String)((String)pair.getSecond()))).map(pair -> Pair.of((Object)((Object)((Priority)((Object)((Object)pair.getFirst())))), (Object)I18n.m_118938_((String)((String)pair.getSecond()), (Object[])new Object[0]))), this.getAllModules(itemStack).stream().filter(module -> headLeftKey.equals(module.getSlot()) || module.getItemPrefixPriority(itemStack) != Priority.BASE).map(module -> Pair.of((Object)((Object)module.getItemPrefixPriority(itemStack)), (Object)module.getItemPrefix(itemStack))).filter(pair -> pair.getSecond() != null)).sorted(Comparator.comparing(Pair::getFirst).reversed()).limit(2L).map(Pair::getSecond).reduce("", (result, prefix) -> result + prefix + " ");
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        Multimap moduleAttributes = (Multimap)Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).map(module -> module.getAttributeModifiers(itemStack)).filter(Objects::nonNull).map(modifiers -> (ArrayListMultimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(Multimap::entries).flatMap(Collection::stream).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        moduleAttributes = AttributeHelper.retainMax((Multimap<Attribute, AttributeModifier>)moduleAttributes, Attributes.f_22281_);
        moduleAttributes = this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(module -> module.getAttributeModifiers(itemStack)).reduce(moduleAttributes, AttributeHelper::merge);
        return Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.attributes).reduce(moduleAttributes, AttributeHelper::merge);
    }

    @Override
    public ToolData getToolDataRaw(ItemStack itemStack) {
        logger.debug("Gathering tool data for {} ({})", (Object)this.m_7626_(itemStack).getString(), (Object)this.getDataCacheKey(itemStack));
        ToolData result = ToolData.retainMax(Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).map(module -> module.getToolData(itemStack)).filter(Objects::nonNull).collect(Collectors.toList()));
        return Stream.concat(this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(module -> module.getToolData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.tools)).filter(Objects::nonNull).reduce(result, ToolData::merge);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (entity != null && itemStack.equals(entity.m_21211_())) {
            return Optional.ofNullable(this.getChargeableAbility(itemStack)).map(ChargedAbilityEffect::getModelTransform).map(transform -> super.getModelCacheKey(itemStack, entity) + ":" + transform).orElseGet(() -> super.getModelCacheKey(itemStack, entity));
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        ChargedAbilityEffect ability = this.getChargeableAbility(itemStack);
        if (entity != null && ability != null && itemStack.equals(entity.m_21211_())) {
            return ability.getModelTransform();
        }
        return null;
    }
}

