/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class PotionItemGui
extends GuiElement {
    private final ItemStack itemStack;
    private final int slot;
    private final Minecraft mc;
    private final KeyframeAnimation showAnimation;
    GuiTexture backdrop;

    public PotionItemGui(int x, int y, ItemStack itemStack, int slot, boolean animateUp) {
        super(x, y, 23, 23);
        this.setAttachmentPoint(GuiAttachment.middleLeft);
        this.setAttachmentAnchor(GuiAttachment.middleLeft);
        this.itemStack = itemStack;
        this.slot = slot;
        this.mc = Minecraft.m_91087_();
        this.backdrop = new GuiTexture(0, 0, 23, 23, 32, 28, GuiTextures.toolbelt);
        this.addChild((GuiElement)this.backdrop);
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY(animateUp ? (float)(y + 2) : (float)(y - 2), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay((int)(Math.random() * 300.0));
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        return true;
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.opacity == 1.0f) {
            this.drawItemStack(this.itemStack, this.x + refX + 3, this.y + refY + 2);
        }
    }

    private void drawItemStack(ItemStack itemStack, int x, int y) {
        PoseStack renderSystemStack = RenderSystem.m_157191_();
        renderSystemStack.m_85836_();
        GlStateManager.m_84513_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.m_91291_().m_115203_(itemStack, x, y);
        this.mc.m_91291_().m_115174_(this.mc.f_91062_, itemStack, x, y, "");
        GlStateManager.m_84507_();
        renderSystemStack.m_85849_();
    }

    public int getSlot() {
        return this.slot;
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
    }

    public void updateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = (mouseX -= refX + this.x) + (mouseY -= refY + this.y) >= 12;
        if (mouseX + mouseY > 34) {
            gainFocus = false;
        }
        if (mouseX - mouseY > 8) {
            gainFocus = false;
        }
        if (mouseY - mouseX > 12) {
            gainFocus = false;
        }
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

