/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class AttributeHelper {
    public static final Multimap<Attribute, AttributeModifier> emptyMap = ImmutableMultimap.of();
    private static final Map<String, UUID> attributeIdMap = new HashMap<String, UUID>();

    public static Multimap<Attribute, AttributeModifier> overwrite(Multimap<Attribute, AttributeModifier> a, Multimap<Attribute, AttributeModifier> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(a);
        b.asMap().forEach((x$0, x$1) -> result.replaceValues(x$0, x$1));
        return result;
    }

    public static Multimap<Attribute, AttributeModifier> merge(Collection<Multimap<Attribute, AttributeModifier>> modifiers) {
        return modifiers.stream().reduce(null, AttributeHelper::merge);
    }

    public static Multimap<Attribute, AttributeModifier> merge(Multimap<Attribute, AttributeModifier> a, Multimap<Attribute, AttributeModifier> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(a);
        b.forEach((x$0, x$1) -> result.put(x$0, x$1));
        return result;
    }

    public static Multimap<Attribute, AttributeModifier> retainMax(Multimap<Attribute, AttributeModifier> modifiers, Attribute ... attributes) {
        return AttributeHelper.retainMax(modifiers, Arrays.asList(attributes));
    }

    public static Multimap<Attribute, AttributeModifier> retainMax(Multimap<Attribute, AttributeModifier> modifiers, Collection<Attribute> attributes) {
        if (modifiers == null) {
            return null;
        }
        return (Multimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> attributes.contains(entry.getKey()) ? AttributeHelper.retainMax((Collection)entry.getValue()).stream() : ((Collection)entry.getValue()).stream(), ArrayListMultimap::create));
    }

    public static Collection<AttributeModifier> retainMax(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().collect(Collectors.groupingBy(AttributeModifier::m_22217_, Collectors.maxBy(Comparator.comparing(AttributeModifier::m_22218_)))).values().stream().map(Optional::get).collect(Collectors.toList());
    }

    public static Collection<AttributeModifier> collapse(Collection<AttributeModifier> modifiers) {
        return Stream.of(Optional.of(AttributeHelper.getAdditionAmount(modifiers)).filter(amount -> amount != 0.0).map(amount -> new AttributeModifier("tetra.stats.addition", amount.doubleValue(), AttributeModifier.Operation.ADDITION)), Optional.of(AttributeHelper.getMultiplyAmount(modifiers)).map(amount -> amount - 1.0).filter(amount -> amount != 0.0).map(amount -> new AttributeModifier("tetra.stats.multiply", amount.doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static double getMergedAmount(Collection<AttributeModifier> modifiers) {
        return AttributeHelper.getMergedAmount(modifiers, 0.0);
    }

    public static double getMergedAmount(Collection<AttributeModifier> modifiers, double base) {
        return (AttributeHelper.getAdditionAmount(modifiers) + base) * AttributeHelper.getMultiplyAmount(modifiers);
    }

    public static double getAdditionAmount(Collection<AttributeModifier> modifiers) {
        double base = modifiers.stream().filter(modifier -> modifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)).mapToDouble(AttributeModifier::m_22218_).sum();
        return base + modifiers.stream().filter(modifier -> modifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)).mapToDouble(AttributeModifier::m_22218_).map(amount -> amount * Math.abs(base)).sum();
    }

    public static double getMultiplyAmount(Collection<AttributeModifier> modifiers) {
        return modifiers.stream().filter(modifier -> modifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)).mapToDouble(AttributeModifier::m_22218_).map(amount -> amount + 1.0).reduce(1.0, (a, b) -> a * b);
    }

    public static Multimap<Attribute, AttributeModifier> multiplyModifiers(Multimap<Attribute, AttributeModifier> modifiers, double multiplier) {
        return Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.toMultimap(Map.Entry::getKey, entry -> AttributeHelper.multiplyModifier((AttributeModifier)entry.getValue(), multiplier), ArrayListMultimap::create))).orElse(null);
    }

    public static AttributeModifier multiplyModifier(AttributeModifier modifier, double multiplier) {
        return new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), modifier.m_22218_() * multiplier, modifier.m_22217_());
    }

    public static Multimap<Attribute, AttributeModifier> collapseRound(Multimap<Attribute, AttributeModifier> modifiers) {
        return Optional.ofNullable(modifiers).map(Multimap::asMap).map(Map::entrySet).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(AttributeHelper::round).orElse(null);
    }

    public static Multimap<Attribute, AttributeModifier> round(Multimap<Attribute, AttributeModifier> modifiers) {
        return (Multimap)Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).orElseGet(Stream::empty).collect(Multimaps.toMultimap(Map.Entry::getKey, e -> AttributeHelper.round((Attribute)e.getKey(), (AttributeModifier)e.getValue()), ArrayListMultimap::create));
    }

    private static AttributeModifier round(Attribute attribute, AttributeModifier mod) {
        double multiplier = (Attributes.f_22281_.equals(attribute) || Attributes.f_22284_.equals(attribute) || Attributes.f_22285_.equals(attribute) || ((Attribute)TetraAttributes.drawStrength.get()).equals(attribute) || ((Attribute)TetraAttributes.abilityDamage.get()).equals(attribute)) && mod.m_22217_() == AttributeModifier.Operation.ADDITION ? 2.0 : 20.0;
        return new AttributeModifier(mod.m_22209_(), mod.m_22214_(), (double)Math.round(mod.m_22218_() * multiplier) / multiplier, mod.m_22217_());
    }

    public static String getAttributeKey(Attribute attribute, AttributeModifier.Operation operation) {
        return attribute.m_22087_() + operation.ordinal();
    }

    private static UUID getAttributeId(Attribute attribute, AttributeModifier.Operation operation) {
        return attributeIdMap.computeIfAbsent(AttributeHelper.getAttributeKey(attribute, operation), k -> Mth.m_14002_());
    }

    public static AttributeModifier fixIdentifiers(Attribute attribute, AttributeModifier modifier) {
        return new AttributeModifier(AttributeHelper.getAttributeId(attribute, modifier.m_22217_()), modifier.m_22214_(), modifier.m_22218_(), modifier.m_22217_());
    }

    public static Multimap<Attribute, AttributeModifier> fixIdentifiers(Multimap<Attribute, AttributeModifier> modifiers) {
        return Optional.ofNullable(modifiers).map(Multimap::entries).map(Collection::stream).map(entries -> (ArrayListMultimap)entries.collect(Multimaps.toMultimap(Map.Entry::getKey, entry -> AttributeHelper.fixIdentifiers((Attribute)entry.getKey(), (AttributeModifier)entry.getValue()), ArrayListMultimap::create))).orElse(null);
    }

    static {
        attributeIdMap.put(AttributeHelper.getAttributeKey(Attributes.f_22281_, AttributeModifier.Operation.ADDITION), ModularItem.attackDamageModifier);
        attributeIdMap.put(AttributeHelper.getAttributeKey(Attributes.f_22283_, AttributeModifier.Operation.ADDITION), ModularItem.attackSpeedModifier);
    }
}

