/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.compiler.BytecodeLoader;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.function.LuaClosure;
import cc.tweaked.internal.cobalt.function.LuaInterpretedFunction;
import java.io.IOException;
import java.io.InputStream;

public final class LoadState {
    private static final byte[] LUA_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static final LuaString SOURCE_BINARY_STRING = ValueFactory.valueOf("=?");
    private static final int NAME_LENGTH = 30;
    private static final int FILE_LENGTH = 30 - " '...' ".length() - 1;
    private static final int STRING_LENGTH = 30 - " [string \"...\"] ".length() - 1;
    private static final LuaString REMAINING = ValueFactory.valueOf("...");
    private static final LuaString STRING = ValueFactory.valueOf("[string \"");
    private static final LuaString EMPTY_STRING = ValueFactory.valueOf("[string \"\"]");
    private static final LuaString NEW_LINES = ValueFactory.valueOf("\r\n");

    public static LuaClosure load(LuaState state, InputStream stream, String name, LuaTable env) throws IOException, CompileException {
        return LoadState.load(state, stream, ValueFactory.valueOf(name), env);
    }

    public static LuaClosure load(LuaState state, InputStream stream, LuaString name, LuaTable env) throws IOException, CompileException {
        return LoadState.load(state, stream, name, null, env);
    }

    public static LuaClosure load(LuaState state, InputStream stream, LuaString name, LuaString mode, LuaTable env) throws IOException, CompileException {
        if (state.compiler != null) {
            return state.compiler.load(stream, name, mode, env);
        }
        int firstByte = stream.read();
        if (firstByte != LUA_SIGNATURE[0]) {
            throw new CompileException("no compiler");
        }
        LoadState.checkMode(mode, "binary");
        Prototype p = LoadState.loadBinaryChunk(firstByte, stream, name);
        LuaInterpretedFunction closure = new LuaInterpretedFunction(p, env);
        closure.nilUpvalues();
        return closure;
    }

    public static Prototype loadBinaryChunk(int firstByte, InputStream stream, LuaString name) throws IOException, CompileException {
        name = LoadState.getSourceName(name);
        if (firstByte != LUA_SIGNATURE[0] || stream.read() != LUA_SIGNATURE[1] || stream.read() != LUA_SIGNATURE[2] || stream.read() != LUA_SIGNATURE[3]) {
            throw new IllegalArgumentException("bad signature");
        }
        BytecodeLoader s = new BytecodeLoader(stream);
        s.loadHeader();
        return s.loadFunction(name);
    }

    public static LuaString getSourceName(LuaString name) {
        if (name.length > 0) {
            byte first = name.bytes[name.offset];
            switch (first) {
                case 61: 
                case 64: {
                    return name.substring(1);
                }
                case 27: {
                    return SOURCE_BINARY_STRING;
                }
            }
            return name;
        }
        return name;
    }

    public static LuaString getShortName(LuaString name) {
        if (name.length == 0) {
            return EMPTY_STRING;
        }
        switch (name.luaByte(0)) {
            case 61: {
                return name.substring(1, Math.min(30, name.length));
            }
            case 64: {
                if (name.length - 1 > FILE_LENGTH) {
                    byte[] bytes = new byte[FILE_LENGTH + 3];
                    REMAINING.copyTo(bytes, 0);
                    name.copyTo(name.length - FILE_LENGTH, bytes, LoadState.REMAINING.length, FILE_LENGTH);
                    return ValueFactory.valueOf(bytes);
                }
                return name.substring(1);
            }
        }
        int len = name.indexOfAny(NEW_LINES);
        boolean truncate = false;
        if (len < 0) {
            len = name.length;
        } else {
            truncate = true;
        }
        if (len > STRING_LENGTH) {
            truncate = true;
            len = STRING_LENGTH;
        }
        byte[] out = new byte[30];
        STRING.copyTo(out, 0);
        int offset = LoadState.STRING.length;
        offset = name.copyTo(0, out, offset, len);
        if (truncate) {
            offset = REMAINING.copyTo(out, offset);
        }
        out[offset++] = 34;
        out[offset++] = 93;
        return LuaString.valueOf(out, 0, offset);
    }

    public static void checkMode(LuaString mode, String current) throws CompileException {
        if (mode != null && mode.indexOf((byte)current.charAt(0), 0) == -1) {
            throw new CompileException("attempt to load a " + current + " chunk (mode is " + mode + ")");
        }
    }

    public static interface LuaCompiler {
        public LuaClosure load(InputStream var1, LuaString var2, LuaString var3, LuaTable var4) throws IOException, CompileException;
    }
}

