/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LuaValues {
    private LuaValues() {
    }

    @Nonnull
    public static ByteBuffer encode(@Nonnull String string) {
        byte[] chars = new byte[string.length()];
        for (int i = 0; i < chars.length; ++i) {
            char c = string.charAt(i);
            chars[i] = c < '\u0100' ? (int)c : 63;
        }
        return ByteBuffer.wrap(chars).asReadOnlyBuffer();
    }

    @Nonnull
    public static String getNumericType(double value) {
        if (Double.isNaN(value)) {
            return "nan";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        return "number";
    }

    @Nonnull
    public static String getType(@Nullable Object value) {
        if (value == null) {
            return "nil";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Map) {
            return "table";
        }
        return "userdata";
    }

    @Nonnull
    public static LuaException badArgumentOf(int index, @Nonnull String expected, @Nullable Object actual) {
        return LuaValues.badArgument(index, expected, LuaValues.getType(actual));
    }

    @Nonnull
    public static LuaException badArgument(int index, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("bad argument #" + (index + 1) + " (" + expected + " expected, got " + actual + ")");
    }

    @Nonnull
    public static LuaException badTableItem(int index, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("table item #" + index + " is not " + expected + " (got " + actual + ")");
    }

    @Nonnull
    public static LuaException badField(String key, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("field " + key + " is not " + expected + " (got " + actual + ")");
    }

    public static Number checkFiniteNum(int index, Number value) throws LuaException {
        LuaValues.checkFinite(index, value.doubleValue());
        return value;
    }

    public static double checkFinite(int index, double value) throws LuaException {
        if (!Double.isFinite(value)) {
            throw LuaValues.badArgument(index, "number", LuaValues.getNumericType(value));
        }
        return value;
    }

    public static <T extends Enum<T>> T checkEnum(int index, Class<T> klass, String value) throws LuaException {
        for (Enum possibility : (Enum[])klass.getEnumConstants()) {
            if (!possibility.name().equalsIgnoreCase(value)) continue;
            return (T)possibility;
        }
        throw new LuaException("bad argument #" + (index + 1) + " (unknown option " + value + ")");
    }
}

