/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformedBakedModel
extends BakedModelWrapper<BakedModel> {
    private final Transformation transformation;
    private final boolean isIdentity;

    public TransformedBakedModel(BakedModel model, Transformation transformation) {
        super(model);
        this.transformation = transformation;
        this.isIdentity = transformation.isIdentity();
    }

    public TransformedBakedModel(TransformedModel model) {
        this(model.getModel(), model.getMatrix());
    }

    @Nonnull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        List quads = this.originalModel.getQuads(state, side, rand, extraData, renderType);
        return this.isIdentity ? quads : QuadTransformers.applying((Transformation)this.transformation).process(quads);
    }

    public TransformedBakedModel composeWith(Transformation other) {
        return new TransformedBakedModel(this.originalModel, other.m_121096_(this.transformation));
    }
}

