/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import java.util.ArrayDeque;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class ResourceQueue<T extends Resource<T>>
extends ResourceGroup<T> {
    private final ArrayDeque<Supplier<T>> pending = new ArrayDeque();

    public ResourceQueue(IntSupplier limit) {
        super(limit);
    }

    public ResourceQueue() {
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.pending.clear();
    }

    @Override
    public synchronized boolean queue(Supplier<T> resource) {
        if (!this.active) {
            return false;
        }
        if (super.queue(resource)) {
            return true;
        }
        if (this.pending.size() > 512) {
            return false;
        }
        this.pending.add(resource);
        return true;
    }

    @Override
    public synchronized void release(T resource) {
        Supplier<T> next;
        super.release(resource);
        if (!this.active) {
            return;
        }
        int limit = this.limit.getAsInt();
        if ((limit <= 0 || this.resources.size() < limit) && (next = this.pending.poll()) != null) {
            this.resources.add((Resource)next.get());
        }
    }
}

