/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.Registry;
import java.util.Optional;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class ItemModelGenerator {
    private ItemModelGenerator() {
    }

    public static void addItemModels(ItemModelGenerators generators) {
        ItemModelGenerator.registerDisk(generators, (Item)Registry.ModItems.DISK.get());
        ItemModelGenerator.registerDisk(generators, (Item)Registry.ModItems.TREASURE_DISK.get());
        ItemModelGenerator.registerPocketComputer(generators, ModelLocationUtils.m_125571_((Item)((Item)Registry.ModItems.POCKET_COMPUTER_NORMAL.get())), false);
        ItemModelGenerator.registerPocketComputer(generators, ModelLocationUtils.m_125571_((Item)((Item)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())), false);
        ItemModelGenerator.registerPocketComputer(generators, new ResourceLocation("computercraft", "item/pocket_computer_colour"), true);
        generators.m_125088_((Item)Registry.ModItems.PRINTED_BOOK.get(), ModelTemplates.f_125658_);
        generators.m_125088_((Item)Registry.ModItems.PRINTED_PAGE.get(), ModelTemplates.f_125658_);
        generators.m_125088_((Item)Registry.ModItems.PRINTED_PAGES.get(), ModelTemplates.f_125658_);
    }

    private static void registerPocketComputer(ItemModelGenerators generators, ResourceLocation id, boolean off) {
        ItemModelGenerator.createFlatItem(generators, ItemModelGenerator.addSuffix(id, "_blinking"), new ResourceLocation("computercraft", "item/pocket_computer_blink"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        ItemModelGenerator.createFlatItem(generators, ItemModelGenerator.addSuffix(id, "_on"), new ResourceLocation("computercraft", "item/pocket_computer_on"), id, new ResourceLocation("computercraft", "item/pocket_computer_light"));
        if (off) {
            ItemModelGenerator.createFlatItem(generators, id, new ResourceLocation("computercraft", "item/pocket_computer_frame"), id);
        }
    }

    private static void registerDisk(ItemModelGenerators generators, Item item) {
        ItemModelGenerator.createFlatItem(generators, item, new ResourceLocation("computercraft", "item/disk_frame"), new ResourceLocation("computercraft", "item/disk_colour"));
    }

    private static void createFlatItem(ItemModelGenerators generators, Item item, ResourceLocation ... ids) {
        ItemModelGenerator.createFlatItem(generators, ModelLocationUtils.m_125571_((Item)item), ids);
    }

    private static void createFlatItem(ItemModelGenerators generators, ResourceLocation model, ResourceLocation ... textures) {
        if (textures.length > 5) {
            throw new IndexOutOfBoundsException("Too many layers");
        }
        if (textures.length == 0) {
            throw new IndexOutOfBoundsException("Must have at least one texture");
        }
        if (textures.length == 1) {
            ModelTemplates.f_125658_.m_125612_(model, TextureMapping.m_125820_((ResourceLocation)textures[0]), generators.f_125080_);
            return;
        }
        TextureSlot[] slots = new TextureSlot[textures.length];
        TextureMapping mapping = new TextureMapping();
        for (int i = 0; i < textures.length; ++i) {
            TextureSlot slot = slots[i] = TextureSlot.m_125898_((String)("layer" + i));
            mapping.m_125758_(slot, textures[i]);
        }
        new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), slots).m_125612_(model, mapping, generators.f_125080_);
    }

    private static ResourceLocation addSuffix(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix);
    }
}

