/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PocketComputerDataMessage
implements NetworkMessage {
    private final int instanceId;
    private final ComputerState state;
    private final int lightState;
    private final TerminalState terminal;

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this.instanceId = computer.getInstanceID();
        this.state = computer.getState();
        this.lightState = computer.getLight();
        this.terminal = sendTerminal ? computer.getTerminalState() : new TerminalState((NetworkedTerminal)null);
    }

    public PocketComputerDataMessage(FriendlyByteBuf buf) {
        this.instanceId = buf.m_130242_();
        this.state = (ComputerState)buf.m_130066_(ComputerState.class);
        this.lightState = buf.m_130242_();
        this.terminal = new TerminalState(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.instanceId);
        buf.m_130068_((Enum)this.state);
        buf.m_130130_(this.lightState);
        this.terminal.write(buf);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        PocketComputerData computer = ClientPocketComputers.get(this.instanceId, this.terminal.colour);
        computer.setState(this.state, this.lightState);
        if (this.terminal.hasTerminal()) {
            computer.setTerminal(this.terminal);
        }
    }
}

