/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MouseEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_CLICK = 0;
    public static final int TYPE_DRAG = 1;
    public static final int TYPE_UP = 2;
    public static final int TYPE_SCROLL = 3;
    private final int type;
    private final int x;
    private final int y;
    private final int arg;

    public MouseEventServerMessage(AbstractContainerMenu menu, int type, int arg, int x, int y) {
        super(menu);
        this.type = type;
        this.arg = arg;
        this.x = x;
        this.y = y;
    }

    public MouseEventServerMessage(@Nonnull FriendlyByteBuf buf) {
        super(buf);
        this.type = buf.readByte();
        this.arg = buf.m_130242_();
        this.x = buf.m_130242_();
        this.y = buf.m_130242_();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.type);
        buf.m_130130_(this.arg);
        buf.m_130130_(this.x);
        buf.m_130130_(this.y);
    }

    @Override
    protected void handle(NetworkEvent.Context context, @Nonnull ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        switch (this.type) {
            case 0: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case 1: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case 2: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case 3: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }
}

