/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RecordUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;

public final class TileDiskDrive
extends TileGeneric
implements DefaultInventory,
Nameable,
MenuProvider {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_ITEM = "Item";
    Component customName;
    private LockCode lockCode = LockCode.f_19102_;
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    @Nonnull
    private ItemStack diskStack = ItemStack.f_41583_;
    private LazyOptional<IItemHandlerModifiable> itemHandlerCap;
    private LazyOptional<IPeripheral> peripheralCap;
    private IMount diskMount = null;
    private boolean recordQueued = false;
    private boolean recordPlaying = false;
    private boolean restartRecord = false;
    private boolean ejectQueued;

    public TileDiskDrive(BlockEntityType<TileDiskDrive> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void destroy() {
        this.ejectContents(true);
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap = CapabilityUtil.invalidate(this.itemHandlerCap);
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Override
    public boolean isUsable(Player player) {
        return super.isUsable(player) && BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lockCode, (Component)this.m_5446_());
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_()) {
            ItemStack disk = player.m_21120_(hand);
            if (disk.m_41619_()) {
                return InteractionResult.PASS;
            }
            if (!this.m_58904_().f_46443_ && this.m_8020_(0).m_41619_() && MediaProviders.get(disk) != null) {
                this.setDiskStack(disk);
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_58904_().f_46443_ && this.isUsable(player)) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
        }
        return InteractionResult.SUCCESS;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockDiskDrive.FACING);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        MutableComponent mutableComponent = this.customName = nbt.m_128441_(NBT_NAME) ? Component.Serializer.m_130701_((String)nbt.m_128461_(NBT_NAME)) : null;
        if (nbt.m_128441_(NBT_ITEM)) {
            CompoundTag item = nbt.m_128469_(NBT_ITEM);
            this.diskStack = ItemStack.m_41712_((CompoundTag)item);
            this.diskMount = null;
        }
        this.lockCode = LockCode.m_19111_((CompoundTag)nbt);
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        if (this.customName != null) {
            nbt.m_128359_(NBT_NAME, Component.Serializer.m_130703_((Component)this.customName));
        }
        if (!this.diskStack.m_41619_()) {
            CompoundTag item = new CompoundTag();
            this.diskStack.m_41739_(item);
            nbt.m_128365_(NBT_ITEM, (Tag)item);
        }
        this.lockCode.m_19109_(nbt);
        super.m_183515_(nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverTick() {
        if (this.ejectQueued) {
            this.ejectContents(false);
            this.ejectQueued = false;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.recordPlaying != this.recordQueued || this.restartRecord) {
                this.restartRecord = false;
                if (this.recordQueued) {
                    SoundEvent record;
                    IMedia contents = this.getDiskMedia();
                    SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.diskStack) : null;
                    if (record != null) {
                        this.recordPlaying = true;
                        this.playRecord();
                    } else {
                        this.recordQueued = false;
                    }
                } else {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.diskStack.m_41619_();
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.diskStack;
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        ItemStack result = this.diskStack;
        this.diskStack = ItemStack.f_41583_;
        this.diskMount = null;
        return result;
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        if (this.diskStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.diskStack.m_41613_() <= count) {
            ItemStack disk = this.diskStack;
            this.m_6836_(slot, ItemStack.f_41583_);
            return disk;
        }
        ItemStack part = this.diskStack.m_41620_(count);
        this.m_6836_(slot, this.diskStack.m_41619_() ? ItemStack.f_41583_ : this.diskStack);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        if (this.m_58904_().f_46443_) {
            this.diskStack = stack;
            this.diskMount = null;
            this.m_6596_();
            return;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            Set<IComputerAccess> computers;
            if (InventoryUtil.areItemsStackable(stack, this.diskStack)) {
                this.diskStack = stack;
                return;
            }
            if (!this.diskStack.m_41619_()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.unmountDisk(computer);
                }
            }
            if (this.recordPlaying) {
                this.stopRecord();
                this.recordPlaying = false;
                this.recordQueued = false;
            }
            this.diskStack = stack;
            this.diskMount = null;
            this.m_6596_();
            if (!this.diskStack.m_41619_()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.mountDisk(computer);
                }
            }
        }
    }

    public void m_6596_() {
        if (!this.f_58857_.f_46443_) {
            this.updateBlockState();
        }
        super.m_6596_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.isUsable(player);
    }

    public void m_6211_() {
        this.m_6836_(0, ItemStack.f_41583_);
    }

    @Nonnull
    ItemStack getDiskStack() {
        return this.m_8020_(0);
    }

    void setDiskStack(@Nonnull ItemStack stack) {
        this.m_6836_(0, stack);
    }

    private IMedia getDiskMedia() {
        return MediaProviders.get(this.getDiskStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDiskMountPath(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.computers.put(computer, new MountInfo());
            this.mountDisk(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.unmountDisk(computer);
            this.computers.remove(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            IMedia media = this.getDiskMedia();
            if (media != null && media.getAudioTitle(this.diskStack) != null) {
                this.recordQueued = true;
                this.restartRecord = this.recordPlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.recordQueued = false;
            this.restartRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ejectDisk() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.ejectQueued = true;
        }
    }

    private synchronized void mountDisk(IComputerAccess computer) {
        if (!this.diskStack.m_41619_()) {
            MountInfo info = this.computers.get(computer);
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                if (this.diskMount == null) {
                    this.diskMount = contents.createDataMount(this.diskStack, this.m_58904_());
                }
                if (this.diskMount != null) {
                    if (this.diskMount instanceof IWritableMount) {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), (IWritableMount)this.diskMount);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mount((String)(n == 1 ? "disk" : "disk" + n), this.diskMount);
                            ++n;
                        }
                    }
                } else {
                    info.mountPath = null;
                }
            }
            computer.queueEvent("disk", computer.getAttachmentName());
        }
    }

    private synchronized void unmountDisk(IComputerAccess computer) {
        if (!this.diskStack.m_41619_()) {
            MountInfo info = this.computers.get(computer);
            assert (info != null);
            if (info.mountPath != null) {
                computer.unmount(info.mountPath);
                info.mountPath = null;
            }
            computer.queueEvent("disk_eject", computer.getAttachmentName());
        }
    }

    private void updateBlockState() {
        if (this.f_58859_ || this.f_58857_ == null) {
            return;
        }
        if (!this.diskStack.m_41619_()) {
            IMedia contents = this.getDiskMedia();
            this.updateBlockState(contents != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        } else {
            this.updateBlockState(DiskDriveState.EMPTY);
        }
    }

    private void updateBlockState(DiskDriveState state) {
        BlockState blockState = this.m_58900_();
        if (blockState.m_61143_(BlockDiskDrive.STATE) == state) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_(BlockDiskDrive.STATE, (Comparable)((Object)state)));
    }

    private synchronized void ejectContents(boolean destroyed) {
        if (this.m_58904_().f_46443_ || this.diskStack.m_41619_()) {
            return;
        }
        ItemStack disks = this.diskStack;
        this.setDiskStack(ItemStack.f_41583_);
        int xOff = 0;
        int zOff = 0;
        if (!destroyed) {
            Direction dir = this.getDirection();
            xOff = dir.m_122429_();
            zOff = dir.m_122431_();
        }
        BlockPos pos = this.m_58899_();
        double x = (double)pos.m_123341_() + 0.5 + (double)xOff * 0.5;
        double y = (double)pos.m_123342_() + 0.75;
        double z = (double)pos.m_123343_() + 0.5 + (double)zOff * 0.5;
        ItemEntity entityitem = new ItemEntity(this.m_58904_(), x, y, z, disks);
        entityitem.m_20334_((double)xOff * 0.15, 0.0, (double)zOff * 0.15);
        this.m_58904_().m_7967_((Entity)entityitem);
        if (!destroyed) {
            this.m_58904_().m_6798_(1000, this.m_58899_(), 0);
        }
    }

    private void playRecord() {
        SoundEvent record;
        IMedia contents = this.getDiskMedia();
        SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.diskStack) : null;
        if (record != null) {
            RecordUtil.playRecord(record, contents.getAudioTitle(this.diskStack), this.m_58904_(), this.m_58899_());
        } else {
            RecordUtil.playRecord(null, null, this.m_58904_(), this.m_58899_());
        }
    }

    private void stopRecord() {
        RecordUtil.playRecord(null, null, this.m_58904_(), this.m_58899_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new InvWrapper((Container)this));
            }
            return this.itemHandlerCap.cast();
        }
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> new DiskDrivePeripheral(this));
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    @Nonnull
    public Component m_7755_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nonnull
    public Component m_5446_() {
        return super.m_5446_();
    }

    @Nonnull
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        return new ContainerDiskDrive(id, inventory, this);
    }

    private static class MountInfo {
        String mountPath;

        private MountInfo() {
        }
    }
}

