/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.recipes;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public final class PocketComputerUpgradeRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<PocketComputerUpgradeRecipe> SERIALIZER = new SimpleRecipeSerializer(PocketComputerUpgradeRecipe::new);

    private PocketComputerUpgradeRecipe(ResourceLocation identifier) {
        super(identifier);
    }

    public boolean m_8004_(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.NORMAL, null);
    }

    public boolean matches(@Nonnull CraftingContainer inventory, @Nonnull Level world) {
        return !this.assemble(inventory).m_41619_();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inventory) {
        ItemStack computer = ItemStack.f_41583_;
        int computerX = -1;
        int computerY = -1;
        block0: for (int y = 0; y < inventory.m_39346_(); ++y) {
            for (int x = 0; x < inventory.m_39347_(); ++x) {
                ItemStack item = inventory.m_8020_(x + y * inventory.m_39347_());
                if (item.m_41619_() || !(item.m_41720_() instanceof ItemPocketComputer)) continue;
                computer = item;
                computerX = x;
                computerY = y;
                break block0;
            }
        }
        if (computer.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemPocketComputer itemComputer = (ItemPocketComputer)computer.m_41720_();
        if (ItemPocketComputer.getUpgrade(computer) != null) {
            return ItemStack.f_41583_;
        }
        IPocketUpgrade upgrade = null;
        for (int y = 0; y < inventory.m_39346_(); ++y) {
            for (int x = 0; x < inventory.m_39347_(); ++x) {
                ItemStack item = inventory.m_8020_(x + y * inventory.m_39347_());
                if (x == computerX && y == computerY || !(x == computerX && y == computerY - 1 ? (upgrade = PocketUpgrades.instance().get(item)) == null : !item.m_41619_())) continue;
                return ItemStack.f_41583_;
            }
        }
        if (upgrade == null) {
            return ItemStack.f_41583_;
        }
        ComputerFamily family = itemComputer.getFamily();
        int computerID = itemComputer.getComputerID(computer);
        String label = itemComputer.getLabel(computer);
        int colour = itemComputer.getColour(computer);
        return PocketComputerItemFactory.create(computerID, label, colour, family, upgrade);
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

