/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Queue<Token> toTick = new ConcurrentLinkedDeque<Token>();

    private TickScheduler() {
    }

    public static void schedule(Token token) {
        Level world = token.owner.m_58904_();
        if (world != null && !world.f_46443_ && !token.scheduled.getAndSet(true)) {
            toTick.add(token);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        Token token;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        while ((token = toTick.poll()) != null) {
            token.scheduled.set(false);
            BlockEntity blockEntity = token.owner;
            if (blockEntity.m_58901_()) continue;
            Level world = blockEntity.m_58904_();
            BlockPos pos = blockEntity.m_58899_();
            if (world == null || !world.m_46749_(pos) || world.m_7702_(pos) != blockEntity) continue;
            world.m_186460_(pos, blockEntity.m_58900_().m_60734_(), 0);
        }
    }

    public static class Token {
        final BlockEntity owner;
        final AtomicBoolean scheduled = new AtomicBoolean();

        public Token(BlockEntity owner) {
            this.owner = owner;
        }
    }
}

