/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;
import org.dynmap.Color;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.debug.Debug;
import org.dynmap.renderer.DynmapBlockState;

public class ColorScheme {
    private static final HashMap<String, ColorScheme> cache = new HashMap();
    public String name;
    public final Color[][] colors;
    public final Color[][] biomecolors;
    public final Color[][] raincolors;
    public final Color[][] tempcolors;

    public ColorScheme(String name, Color[][] colors, Color[][] biomecolors, Color[][] raincolors, Color[][] tempcolors) {
        this.name = name;
        this.colors = colors;
        this.biomecolors = biomecolors;
        this.raincolors = raincolors;
        this.tempcolors = tempcolors;
    }

    private static File getColorSchemeDirectory(DynmapCore core) {
        return new File(core.getDataFolder(), "colorschemes");
    }

    public static ColorScheme getScheme(DynmapCore core, String name) {
        ColorScheme scheme;
        if (name == null) {
            name = "default";
        }
        if ((scheme = cache.get(name)) == null) {
            scheme = ColorScheme.loadScheme(core, name);
            cache.put(name, scheme);
        }
        return scheme;
    }

    public static ColorScheme loadScheme(DynmapCore core, String name) {
        File colorSchemeFile = new File(ColorScheme.getColorSchemeDirectory(core), name + ".txt");
        Color[][] colors = new Color[DynmapBlockState.getGlobalIndexMax()][];
        Color[][] biomecolors = new Color[BiomeMap.values().length][];
        Color[][] raincolors = new Color[64][];
        Color[][] tempcolors = new Color[64][];
        for (int i = 0; i < biomecolors.length; ++i) {
            Color[] c = new Color[5];
            int red = 0x80 | 64 * (i >> 0 & 1) | 32 * (i >> 3 & 1) | 16 * (i >> 6 & 1);
            int green = 0x80 | 64 * (i >> 1 & 1) | 32 * (i >> 4 & 1) | 16 * (i >> 7 & 1);
            int blue = 0x80 | 64 * (i >> 2 & 1) | 32 * (i >> 5 & 1);
            c[0] = new Color(red, green, blue);
            c[3] = new Color(red * 4 / 5, green * 4 / 5, blue * 4 / 5);
            c[1] = new Color(red / 2, green / 2, blue / 2);
            c[2] = new Color(red * 2 / 5, green * 2 / 5, blue * 2 / 5);
            c[4] = new Color((c[1].getRed() + c[3].getRed()) / 2, (c[1].getGreen() + c[3].getGreen()) / 2, (c[1].getBlue() + c[3].getBlue()) / 2, (c[1].getAlpha() + c[3].getAlpha()) / 2);
            biomecolors[i] = c;
        }
        File[] files = new File[]{new File(ColorScheme.getColorSchemeDirectory(core), "biome_rainfall_temp.txt"), new File(ColorScheme.getColorSchemeDirectory(core), "default.txt"), colorSchemeFile};
        try {
            for (int fidx = 0; fidx < files.length; ++fidx) {
                Debug.debug("Loading colors from '" + files[fidx] + "' for " + name + "...");
                FileInputStream stream = new FileInputStream(files[fidx]);
                Scanner scanner = new Scanner(stream);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#") || line.equals("")) continue;
                    String[] split = line.split("[\t ]");
                    int cnt = 0;
                    for (String s : split) {
                        if (s.length() <= 0) continue;
                        ++cnt;
                    }
                    String[] nsplit = new String[cnt];
                    cnt = 0;
                    for (String s : split) {
                        if (s.length() <= 0) continue;
                        nsplit[cnt] = s;
                        ++cnt;
                    }
                    split = nsplit;
                    if (split.length < 17) continue;
                    Integer id = null;
                    boolean isbiome = false;
                    boolean istemp = false;
                    boolean israin = false;
                    DynmapBlockState state = null;
                    int idx = split[0].indexOf(58);
                    if (idx > 0) {
                        String[] vsplit = split[0].split("[\\[\\]]");
                        state = vsplit.length > 1 ? DynmapBlockState.getStateByNameAndState(vsplit[0], vsplit[1]) : DynmapBlockState.getBaseStateByName(vsplit[0]);
                    } else if (split[0].charAt(0) == '[') {
                        String bio = split[0].substring(1);
                        idx = bio.indexOf(93);
                        if (idx >= 0) {
                            bio = bio.substring(0, idx);
                        }
                        isbiome = true;
                        id = -1;
                        BiomeMap[] bm = BiomeMap.values();
                        for (int i = 0; i < bm.length; ++i) {
                            if (bm[i].getId().equalsIgnoreCase(bio)) {
                                id = i;
                                break;
                            }
                            if (!bio.equalsIgnoreCase("BIOME_" + i)) continue;
                            id = i;
                            break;
                        }
                        if (id < 0) {
                            if (bio.startsWith("RAINFALL-")) {
                                try {
                                    double v = Double.parseDouble(bio.substring(9));
                                    if (v >= 0.0 && v <= 1.0) {
                                        id = (int)(v * 63.0);
                                        israin = true;
                                    }
                                }
                                catch (NumberFormatException v) {}
                            } else if (bio.startsWith("TEMPERATURE-")) {
                                try {
                                    double v = Double.parseDouble(bio.substring(12));
                                    if (v >= 0.0 && v <= 1.0) {
                                        id = (int)(v * 63.0);
                                        istemp = true;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        }
                    } else {
                        id = Integer.parseInt(split[0]);
                        state = DynmapBlockState.getStateByLegacyBlockID(id);
                    }
                    Color[] c = new Color[5];
                    c[0] = new Color(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]));
                    c[3] = new Color(Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]), Integer.parseInt(split[8]));
                    c[1] = new Color(Integer.parseInt(split[9]), Integer.parseInt(split[10]), Integer.parseInt(split[11]), Integer.parseInt(split[12]));
                    c[2] = new Color(Integer.parseInt(split[13]), Integer.parseInt(split[14]), Integer.parseInt(split[15]), Integer.parseInt(split[16]));
                    c[4] = new Color((c[1].getRed() + c[3].getRed()) / 2, (c[1].getGreen() + c[3].getGreen()) / 2, (c[1].getBlue() + c[3].getBlue()) / 2, (c[1].getAlpha() + c[3].getAlpha()) / 2);
                    if (isbiome) {
                        if (istemp) {
                            tempcolors[id.intValue()] = c;
                            continue;
                        }
                        if (israin) {
                            raincolors[id.intValue()] = c;
                            continue;
                        }
                        if (id < 0 || id >= biomecolors.length) continue;
                        biomecolors[id.intValue()] = c;
                        continue;
                    }
                    if (state == null) continue;
                    int stateid = state.globalStateIndex;
                    colors[stateid] = c;
                }
                scanner.close();
            }
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] != null) continue;
                DynmapBlockState bs = DynmapBlockState.getStateByGlobalIndex(i);
                DynmapBlockState bsbase = bs.baseState;
                if (bsbase == null || colors[bsbase.globalStateIndex] == null) continue;
                colors[i] = colors[bsbase.globalStateIndex];
            }
            ColorScheme.interpolateColorTable(tempcolors);
            ColorScheme.interpolateColorTable(raincolors);
        }
        catch (RuntimeException e) {
            Log.severe("Could not load colors '" + name + "' ('" + colorSchemeFile + "').", e);
            return null;
        }
        catch (FileNotFoundException e) {
            Log.severe("Could not load colors '" + name + "' ('" + colorSchemeFile + "'): File not found.", e);
        }
        return new ColorScheme(name, colors, biomecolors, raincolors, tempcolors);
    }

    public static void interpolateColorTable(Color[][] c) {
        int idx = -1;
        for (int k = 0; k < c.length; ++k) {
            int kk;
            if (c[k] == null) {
                if (idx < 0 || k != c.length - 1) continue;
                for (kk = idx + 1; kk <= k; ++kk) {
                    c[kk] = c[idx];
                }
                continue;
            }
            if (idx == -1) {
                for (kk = 0; kk < k; ++kk) {
                    c[kk] = c[k];
                }
                idx = k;
                continue;
            }
            int cnt = c[k].length;
            for (int kk2 = idx + 1; kk2 < k; ++kk2) {
                double interp = (double)(kk2 - idx) / (double)(k - idx);
                Color[] cc = new Color[cnt];
                for (int jj = 0; jj < cnt; ++jj) {
                    cc[jj] = new Color((int)((1.0 - interp) * (double)c[idx][jj].getRed() + interp * (double)c[k][jj].getRed()), (int)((1.0 - interp) * (double)c[idx][jj].getGreen() + interp * (double)c[k][jj].getGreen()), (int)((1.0 - interp) * (double)c[idx][jj].getBlue() + interp * (double)c[k][jj].getBlue()), (int)((1.0 - interp) * (double)c[idx][jj].getAlpha() + interp * (double)c[k][jj].getAlpha()));
                }
                c[kk2] = cc;
            }
            idx = k;
        }
    }

    public Color[] getRainColor(double rain) {
        int idx = (int)(rain * 63.0);
        if (idx >= 0 && idx < this.raincolors.length) {
            return this.raincolors[idx];
        }
        return null;
    }

    public Color[] getTempColor(double temp) {
        int idx = (int)(temp * 63.0);
        if (idx >= 0 && idx < this.tempcolors.length) {
            return this.tempcolors[idx];
        }
        return null;
    }

    public static void reset() {
        cache.clear();
    }
}

