/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.common.chunk;

import java.util.Arrays;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericChunkPos;
import org.dynmap.renderer.DynmapBlockState;

public class GenericChunkSection {
    public final BiomeAccess biomes;
    public final BlockStateAccess blocks;
    public final LightingAccess sky;
    public final LightingAccess emitted;
    public final boolean isEmpty;
    private static BiomeAccess defaultBiome = new BiomeAccessSingle(BiomeMap.NULL);
    private static BlockStateAccess defaultBlockState = new BlockStateAccessSingle(DynmapBlockState.AIR);
    private static LightingAccess defaultLight = new LightingAccessSingle(0);
    public static final GenericChunkSection EMPTY = new GenericChunkSection(defaultBlockState, defaultBiome, new LightingAccessSingle(15), defaultLight, true);

    private GenericChunkSection(BlockStateAccess blks, BiomeAccess bio, LightingAccess skyac, LightingAccess emitac, boolean empty) {
        this.blocks = blks;
        this.biomes = bio;
        this.sky = skyac;
        this.emitted = emitac;
        this.isEmpty = empty;
    }

    public String toString() {
        return String.format("sect(bip:%s)", this.biomes);
    }

    public static interface BiomeAccess {
        public BiomeMap getBiome(int var1, int var2, int var3);

        public BiomeMap getBiome(GenericChunkPos var1);
    }

    public static interface BlockStateAccess {
        public DynmapBlockState getBlock(int var1, int var2, int var3);

        public DynmapBlockState getBlock(GenericChunkPos var1);
    }

    public static interface LightingAccess {
        public int getLight(int var1, int var2, int var3);

        public int getLight(GenericChunkPos var1);
    }

    private static class BiomeAccessSingle
    implements BiomeAccess {
        private final BiomeMap biome;

        BiomeAccessSingle(BiomeMap b) {
            this.biome = b;
        }

        @Override
        public final BiomeMap getBiome(int x, int y, int z) {
            return this.biome;
        }

        @Override
        public final BiomeMap getBiome(GenericChunkPos pos) {
            return this.biome;
        }

        public String toString() {
            return String.format("Biome1(%s)", this.biome);
        }
    }

    private static class BlockStateAccessSingle
    implements BlockStateAccess {
        private final DynmapBlockState block;

        BlockStateAccessSingle(DynmapBlockState bs) {
            this.block = bs;
        }

        @Override
        public final DynmapBlockState getBlock(int x, int y, int z) {
            return this.block;
        }

        @Override
        public final DynmapBlockState getBlock(GenericChunkPos pos) {
            return this.block;
        }
    }

    private static class LightingAccessSingle
    implements LightingAccess {
        private final int light;

        LightingAccessSingle(int lig) {
            this.light = lig & 0xF;
        }

        @Override
        public final int getLight(int x, int y, int z) {
            return this.light;
        }

        @Override
        public final int getLight(GenericChunkPos pos) {
            return this.light;
        }
    }

    public static class Builder {
        private LightingAccess sk;
        private LightingAccess em;
        private DynmapBlockState bsaccumsing;
        private DynmapBlockState[] bsaccum;
        private short[] bsblks;
        private DynmapBlockState[] bspal;
        private BiomeMap baaccumsingle;
        private BiomeMap[] baaccum;
        private boolean empty;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.bsaccumsing = DynmapBlockState.AIR;
            this.bsaccum = null;
            this.baaccumsingle = BiomeMap.NULL;
            this.baaccum = null;
            this.bsblks = null;
            this.bspal = null;
            this.sk = defaultLight;
            this.em = defaultLight;
            this.empty = true;
        }

        public Builder singleSkyLight(int val) {
            this.sk = new LightingAccessSingle(val);
            return this;
        }

        public Builder skyLight(byte[] data) {
            this.sk = new LightingAccess3D(data);
            return this;
        }

        public Builder singleEmittedLight(int val) {
            this.em = new LightingAccessSingle(val);
            return this;
        }

        public Builder emittedLight(byte[] data) {
            this.em = new LightingAccess3D(data);
            return this;
        }

        public Builder singleBiome(BiomeMap bio) {
            this.baaccumsingle = bio;
            this.baaccum = null;
            return this;
        }

        public Builder xzBiome(int x, int z, BiomeMap bio) {
            if (this.baaccum == null || this.baaccum.length != 256) {
                this.baaccum = new BiomeMap[256];
                Arrays.fill(this.baaccum, BiomeMap.NULL);
                this.baaccumsingle = BiomeMap.NULL;
            }
            this.baaccum[((z & 0xF) << 4) + (x & 0xF)] = bio;
            return this;
        }

        public Builder xyzBiome(int xdiv4, int ydiv4, int zdiv4, BiomeMap bio) {
            if (this.baaccum == null || this.baaccum.length != 64) {
                this.baaccum = new BiomeMap[64];
                Arrays.fill(this.baaccum, BiomeMap.NULL);
                this.baaccumsingle = BiomeMap.NULL;
            }
            this.baaccum[((ydiv4 & 3) << 4) + ((zdiv4 & 3) << 2) + (xdiv4 & 3)] = bio;
            return this;
        }

        public Builder singleBlockState(DynmapBlockState block) {
            this.bsaccumsing = block;
            this.bsaccum = null;
            this.bsblks = null;
            this.bspal = null;
            this.empty = block.isAir();
            return this;
        }

        public Builder xyzBlockState(int x, int y, int z, DynmapBlockState block) {
            if (this.bsaccum == null) {
                this.bsaccum = new DynmapBlockState[4096];
                Arrays.fill(this.bsaccum, DynmapBlockState.AIR);
                this.bsaccumsing = DynmapBlockState.AIR;
            }
            this.bsaccum[((y & 0xF) << 8) + ((z & 0xF) << 4) + (x & 0xF)] = block;
            this.empty = false;
            return this;
        }

        public Builder xyzBlockStatePalette(DynmapBlockState[] bspalette) {
            if (this.bsblks == null) {
                this.bsblks = new short[4096];
            }
            this.bspal = Arrays.copyOf(bspalette, bspalette.length);
            return this;
        }

        public Builder xyzBlockStateInPalette(int x, int y, int z, short palidx) {
            if (this.bsblks == null) {
                this.bsblks = new short[4096];
            }
            this.bsblks[((y & 0xF) << 8) + ((z & 0xF) << 4) + (x & 0xF)] = palidx;
            this.empty = false;
            return this;
        }

        public GenericChunkSection buildFrom(GenericChunkSection s, byte[] sky) {
            LightingAccess3D skyA = new LightingAccess3D(sky);
            return new GenericChunkSection(s.blocks, s.biomes, skyA, s.emitted, s.isEmpty);
        }

        public GenericChunkSection buildFrom(GenericChunkSection s, int singlesky) {
            LightingAccessSingle skyA = new LightingAccessSingle(singlesky);
            return new GenericChunkSection(s.blocks, s.biomes, skyA, s.emitted, s.isEmpty);
        }

        public GenericChunkSection build() {
            BiomeAccess ba;
            BlockStateAccess bs;
            if (this.bsaccum != null) {
                DynmapBlockState v = this.bsaccum[0];
                boolean mismatch = false;
                for (int i = 0; i < this.bsaccum.length; ++i) {
                    if (this.bsaccum[i] == v) continue;
                    mismatch = true;
                    break;
                }
                if (!mismatch) {
                    this.bsaccumsing = v;
                    this.bsaccum = null;
                }
            }
            if (this.bsaccum != null) {
                bs = new BlockStateAccess3D(this.bsaccum);
                this.bsaccum = null;
                this.empty = false;
            } else if (this.bspal != null) {
                bs = this.bspal.length == 1 ? new BlockStateAccessSingle(this.bspal[0]) : new BlockStateAccess3DPalette(this.bspal, this.bsblks);
                this.bspal = null;
                this.bsblks = null;
            } else if (this.bsaccumsing == DynmapBlockState.AIR) {
                bs = defaultBlockState;
                this.empty = true;
            } else {
                bs = new BlockStateAccessSingle(this.bsaccumsing);
                this.bsaccumsing = DynmapBlockState.AIR;
            }
            if (this.baaccum != null) {
                BiomeMap v = this.baaccum[0];
                boolean mismatch = false;
                for (int i = 0; i < this.baaccum.length; ++i) {
                    if (this.baaccum[i] == v) continue;
                    mismatch = true;
                    break;
                }
                if (!mismatch) {
                    this.baaccumsingle = v;
                    this.baaccum = null;
                }
            }
            if (this.baaccum != null) {
                ba = this.baaccum.length == 64 ? new BiomeAccess3D(this.baaccum) : new BiomeAccess2D(this.baaccum);
                this.baaccum = null;
            } else if (this.baaccumsingle == BiomeMap.NULL) {
                ba = defaultBiome;
            } else {
                ba = new BiomeAccessSingle(this.baaccumsingle);
                this.baaccumsingle = BiomeMap.NULL;
            }
            return new GenericChunkSection(bs, ba, this.sk, this.em, this.empty);
        }
    }

    private static class LightingAccess3D
    implements LightingAccess {
        private final long[] light = new long[256];

        LightingAccess3D(byte[] lig) {
            if (lig != null) {
                for (int off = 0; off < lig.length && off < 2048; ++off) {
                    int n = off >> 3;
                    this.light[n] = this.light[n] | (0xFFL & (long)lig[off]) << 8 * (off & 7);
                }
            }
        }

        @Override
        public final int getLight(int x, int y, int z) {
            return 0xF & (int)(this.light[16 * (y & 0xF) + (z & 0xF)] >> 4 * (x & 0xF));
        }

        @Override
        public final int getLight(GenericChunkPos pos) {
            return 0xF & (int)(this.light[pos.soffset >> 4] >> 4 * pos.sx);
        }
    }

    private static class BiomeAccess3D
    implements BiomeAccess {
        private final BiomeMap[] biomes;

        BiomeAccess3D(BiomeMap[] b) {
            this.biomes = b;
        }

        @Override
        public final BiomeMap getBiome(int x, int y, int z) {
            return this.biomes[(y & 0xC) << 2 | z & 0xC | (x & 0xC) >> 2];
        }

        @Override
        public final BiomeMap getBiome(GenericChunkPos pos) {
            return this.biomes[pos.sdiv4offset];
        }

        public String toString() {
            return String.format("Biome3D(%s)", Arrays.deepToString(this.biomes));
        }
    }

    private static class BiomeAccess2D
    implements BiomeAccess {
        private final BiomeMap[] biomes;

        BiomeAccess2D(BiomeMap[] b) {
            this.biomes = b;
        }

        @Override
        public final BiomeMap getBiome(int x, int y, int z) {
            return this.biomes[((z & 0xF) << 4) + (x & 0xF)];
        }

        @Override
        public final BiomeMap getBiome(GenericChunkPos pos) {
            return this.biomes[pos.soffset & 0xFF];
        }

        public String toString() {
            return String.format("Biome2D(%s)", Arrays.deepToString(this.biomes));
        }
    }

    private static class BlockStateAccess3DPalette
    implements BlockStateAccess {
        private final DynmapBlockState[] palette;
        private final short[] blocks;

        BlockStateAccess3DPalette(DynmapBlockState[] pal, short[] blks) {
            this.blocks = blks;
            this.palette = pal;
        }

        @Override
        public final DynmapBlockState getBlock(int x, int y, int z) {
            return this.palette[this.blocks[256 * (y & 0xF) + 16 * (z & 0xF) + (x & 0xF)]];
        }

        @Override
        public final DynmapBlockState getBlock(GenericChunkPos pos) {
            return this.palette[this.blocks[pos.soffset]];
        }
    }

    private static class BlockStateAccess3D
    implements BlockStateAccess {
        private final DynmapBlockState[] blocks;

        BlockStateAccess3D(DynmapBlockState[] bs) {
            this.blocks = bs;
        }

        @Override
        public final DynmapBlockState getBlock(int x, int y, int z) {
            return this.blocks[256 * (y & 0xF) + 16 * (z & 0xF) + (x & 0xF)];
        }

        @Override
        public final DynmapBlockState getBlock(GenericChunkPos pos) {
            return this.blocks[pos.soffset];
        }
    }
}

