/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_20;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.PlayerList;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.fabric_1_20.DynmapMod;
import org.dynmap.fabric_1_20.FabricCommandSender;
import org.dynmap.fabric_1_20.FabricPlayer;
import org.dynmap.fabric_1_20.FabricServer;
import org.dynmap.fabric_1_20.FabricWorld;
import org.dynmap.fabric_1_20.VersionCheck;
import org.dynmap.fabric_1_20.command.DmapCommand;
import org.dynmap.fabric_1_20.command.DmarkerCommand;
import org.dynmap.fabric_1_20.command.DynmapCommand;
import org.dynmap.fabric_1_20.command.DynmapExpCommand;
import org.dynmap.fabric_1_20.event.BlockEvents;
import org.dynmap.fabric_1_20.event.CustomServerChunkEvents;
import org.dynmap.fabric_1_20.event.CustomServerLifecycleEvents;
import org.dynmap.fabric_1_20.event.PlayerEvents;
import org.dynmap.fabric_1_20.mixin.BiomeEffectsAccessor;
import org.dynmap.fabric_1_20.permissions.FabricPermissions;
import org.dynmap.fabric_1_20.permissions.FilePermissions;
import org.dynmap.fabric_1_20.permissions.LuckPermissions;
import org.dynmap.fabric_1_20.permissions.OpPermissions;
import org.dynmap.fabric_1_20.permissions.PermissionProvider;
import org.dynmap.permissions.PermissionsHandler;
import org.dynmap.renderer.DynmapBlockState;

public class DynmapPlugin {
    DynmapCore core;
    private PermissionProvider permissions;
    private boolean core_enabled;
    public GenericChunkCache sscache;
    public PlayerList playerList;
    MapManager mapManager;
    private MinecraftServer server;
    public static DynmapPlugin plugin;
    ChatHandler chathandler;
    private HashMap<String, Integer> sortWeights = new HashMap();
    private HashMap<String, FabricWorld> worlds = new HashMap();
    private class_1936 last_world;
    private FabricWorld last_fworld;
    private Map<String, FabricPlayer> players = new HashMap<String, FabricPlayer>();
    private FabricServer fserver;
    private boolean tickregistered = false;
    double tps;
    long lasttick;
    long avgticklen;
    long perTickLimit = 50000000L;
    private boolean useSaveFolder = true;
    private static final String[] TRIGGER_DEFAULTS;
    static final Pattern patternControlCode;
    ConcurrentLinkedQueue<BlockUpdateRec> blockupdatequeue = new ConcurrentLinkedQueue();
    public static DynmapBlockState[] stateByID;
    ConcurrentLinkedQueue<ChatMessage> msgqueue = new ConcurrentLinkedQueue();
    private DynmapCommand dynmapCmd;
    private DmapCommand dmapCmd;
    private DmarkerCommand dmarkerCmd;
    private DynmapExpCommand dynmapexpCmd;
    private PlayerTracker playerTracker = null;
    private WorldTracker worldTracker = null;
    private boolean onblockchange = false;
    private boolean onchunkpopulate = false;
    private boolean onchunkgenerate = false;
    boolean onblockchange_with_id = false;

    DynmapPlugin() {
        plugin = this;
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverStart);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        CustomServerLifecycleEvents.SERVER_STARTED_PRE_WORLD_LOAD.register(this::serverStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStop);
    }

    int getSortWeight(String name) {
        return this.sortWeights.getOrDefault(name, 0);
    }

    void setSortWeight(String name, int wt) {
        this.sortWeights.put(name, wt);
    }

    void dropSortWeight(String name) {
        this.sortWeights.remove(name);
    }

    public void initializeBlockStates() {
        stateByID = new DynmapBlockState[16384];
        Arrays.fill(stateByID, DynmapBlockState.AIR);
        class_2361 bsids = class_2248.field_10651;
        DynmapBlockState basebs = null;
        class_2248 baseb = null;
        int baseidx = 0;
        Iterator iter = bsids.iterator();
        DynmapBlockState.Builder bld = new DynmapBlockState.Builder();
        while (iter.hasNext()) {
            DynmapBlockState dbs;
            String bn;
            class_2960 ui;
            class_2248 b;
            class_2680 bs = (class_2680)iter.next();
            int idx = bsids.method_10206((Object)bs);
            if (idx >= stateByID.length) {
                int plen = stateByID.length;
                stateByID = Arrays.copyOf(stateByID, idx * 11 / 10);
                Arrays.fill(stateByID, plen, stateByID.length, DynmapBlockState.AIR);
            }
            if ((b = bs.method_26204()) != baseb) {
                basebs = null;
                baseidx = idx;
                baseb = b;
            }
            if ((ui = class_7923.field_41175.method_10221((Object)b)) == null || (bn = ui.method_12836() + ":" + ui.method_12832()).equals(DynmapBlockState.AIR_BLOCK)) continue;
            Object statename = "";
            for (class_2769 p : bs.method_28501()) {
                if (((String)statename).length() > 0) {
                    statename = (String)statename + ",";
                }
                statename = (String)statename + p.method_11899() + "=" + bs.method_11654(p).toString();
            }
            int lightAtten = bs.method_26216((class_1922)class_2682.field_12294, class_2338.field_10980) ? 15 : (bs.method_26167((class_1922)class_2682.field_12294, class_2338.field_10980) ? 0 : 1);
            bld.setBaseState(basebs).setStateIndex(idx - baseidx).setBlockName(bn).setStateName((String)statename).setLegacyBlockID(idx).setAttenuatesLight(lightAtten);
            if (bs.method_26231() != null) {
                bld.setMaterial(bs.method_26231().toString());
            }
            if (bs.method_51367()) {
                bld.setSolid();
            }
            if (bs.method_26215()) {
                bld.setAir();
            }
            if (bs.method_26164(class_3481.field_15475)) {
                bld.setLog();
            }
            if (bs.method_26164(class_3481.field_15503)) {
                bld.setLeaves();
            }
            if (!bs.method_26227().method_15769() && !(bs.method_26204() instanceof class_2404)) {
                bld.setWaterlogged();
            }
            DynmapPlugin.stateByID[idx] = dbs = bld.build();
            if (basebs != null) continue;
            basebs = dbs;
        }
    }

    public static final class_1792 getItemByID(int id) {
        return class_1792.method_7875((int)id);
    }

    FabricPlayer getOrAddPlayer(class_3222 player) {
        String name = player.method_5477().getString();
        FabricPlayer fp = this.players.get(name);
        if (fp != null) {
            fp.player = player;
        } else {
            fp = new FabricPlayer(this, player);
            this.players.put(name, fp);
        }
        return fp;
    }

    public FabricServer getFabricServer() {
        return this.fserver;
    }

    private void serverStart(MinecraftServer server) {
        this.server = server;
        this.fserver = new FabricServer(this, server);
        this.onEnable();
    }

    private void serverStarted(MinecraftServer server) {
        this.onStart();
        if (this.core != null) {
            this.core.serverStarted();
        }
    }

    private void serverStop(MinecraftServer server) {
        this.onDisable();
        this.server = null;
    }

    public boolean isOp(String player) {
        String[] ops;
        for (String op : ops = this.server.method_3760().method_14603().method_14636()) {
            if (!op.equalsIgnoreCase(player)) continue;
            return true;
        }
        return this.server.method_3724() && this.server.method_19466(this.server.method_3760().method_14566(player).method_7334());
    }

    boolean hasPerm(class_1657 psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && psender != null && ph.hasPermission(psender.method_5477().getString(), permission)) {
            return true;
        }
        return this.permissions.has(psender, permission);
    }

    boolean hasPermNode(class_1657 psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && psender != null && ph.hasPermissionNode(psender.method_5477().getString(), permission)) {
            return true;
        }
        return this.permissions.hasPermissionNode(psender, permission);
    }

    Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        Set<String> rslt = null;
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null) {
            rslt = ph.hasOfflinePermissions(player, perms);
        }
        Set<String> rslt2 = this.hasOfflinePermissions(player, perms);
        if (rslt != null && rslt2 != null) {
            HashSet<String> newrslt = new HashSet<String>(rslt);
            newrslt.addAll(rslt2);
            rslt = newrslt;
        } else if (rslt2 != null) {
            rslt = rslt2;
        }
        return rslt;
    }

    boolean hasOfflinePermission(String player, String perm) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && ph.hasOfflinePermission(player, perm)) {
            return true;
        }
        return this.permissions.hasOfflinePermission(player, perm);
    }

    void setChatHandler(ChatHandler chatHandler) {
        DynmapPlugin.plugin.chathandler = chatHandler;
    }

    public void loadExtraBiomes(String mcver) {
        int cnt = 0;
        BiomeMap.loadWellKnownByVersion(mcver);
        class_2378<class_1959> biomeRegistry = this.getFabricServer().getBiomeRegistry();
        class_1959[] list = this.getFabricServer().getBiomeList(biomeRegistry);
        for (int i = 0; i < list.length; ++i) {
            class_1959 bb = list[i];
            if (bb == null) continue;
            String id = biomeRegistry.method_10221((Object)bb).method_12832();
            String rl = biomeRegistry.method_10221((Object)bb).toString();
            float tmp = bb.method_8712();
            float hum = bb.field_26393.comp_846();
            int watermult = ((BiomeEffectsAccessor)bb.method_24377()).getWaterColor();
            Log.verboseinfo("biome[" + i + "]: hum=" + hum + ", tmp=" + tmp + ", mult=" + Integer.toHexString(watermult));
            BiomeMap bmap = BiomeMap.NULL;
            bmap = rl != null ? BiomeMap.byBiomeResourceLocation(rl) : BiomeMap.byBiomeID(i);
            if (bmap.isDefault() || bmap == BiomeMap.NULL) {
                bmap = new BiomeMap(rl != null ? -2 : i, id, tmp, hum, rl);
                Log.verboseinfo("Add custom biome [" + bmap.toString() + "] (" + i + ")");
                ++cnt;
            } else {
                bmap.setTemperature(tmp);
                bmap.setRainfall(hum);
            }
            if (watermult != -1) {
                bmap.setWaterColorMultiplier(watermult);
                Log.verboseinfo("Set watercolormult for " + bmap.toString() + " (" + i + ") to " + Integer.toHexString(watermult));
            }
            bmap.setBiomeObject(bb);
        }
        if (cnt > 0) {
            Log.info("Added " + cnt + " custom biome mappings");
        }
    }

    private String[] getBiomeNames() {
        class_2378<class_1959> biomeRegistry = this.getFabricServer().getBiomeRegistry();
        class_1959[] list = this.getFabricServer().getBiomeList(biomeRegistry);
        String[] lst = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            class_1959 bb = list[i];
            if (bb == null) continue;
            lst[i] = biomeRegistry.method_10221((Object)bb).method_12832();
        }
        return lst;
    }

    public void onEnable() {
        String mcver = this.server.method_3827();
        this.loadExtraBiomes(mcver);
        this.registerPlayerLoginListener();
        if (FabricLoader.getInstance().isModLoaded("luckperms")) {
            Log.info("Using luckperms for access control");
            this.permissions = new LuckPermissions();
        } else if (FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) {
            Log.info("Using fabric-permissions-api for access control");
            this.permissions = new FabricPermissions();
        } else {
            this.permissions = FilePermissions.create();
            if (this.permissions == null) {
                this.permissions = new OpPermissions(new String[]{"webchat", "marker.icons", "marker.list", "webregister", "stats", "hide.self", "show.self"});
            }
        }
        File dataDirectory = new File("dynmap");
        if (!dataDirectory.exists()) {
            dataDirectory.mkdirs();
        }
        if (this.core == null) {
            this.core = new DynmapCore();
        }
        this.core.setPluginJarFile(DynmapMod.jarfile);
        this.core.setPluginVersion(DynmapMod.ver);
        this.core.setMinecraftVersion(mcver);
        this.core.setDataFolder(dataDirectory);
        this.core.setServer(this.fserver);
        this.core.setTriggerDefault(TRIGGER_DEFAULTS);
        this.core.setBiomeNames(this.getBiomeNames());
        if (!this.core.initConfiguration(null)) {
            return;
        }
        File filepermexample = new File(this.core.getDataFolder(), "permissions.yml.example");
        this.core.createDefaultFileFromResource("/permissions.yml.example", filepermexample);
        DynmapCommonAPIListener.apiInitialized(this.core);
    }

    public void registerCommands(CommandDispatcher<class_2168> cd) {
        this.dynmapCmd = new DynmapCommand(this);
        this.dmapCmd = new DmapCommand(this);
        this.dmarkerCmd = new DmarkerCommand(this);
        this.dynmapexpCmd = new DynmapExpCommand(this);
        this.dynmapCmd.register(cd);
        this.dmapCmd.register(cd);
        this.dmarkerCmd.register(cd);
        this.dynmapexpCmd.register(cd);
        Log.info("Register commands");
    }

    public void onStart() {
        this.initializeBlockStates();
        if (!this.core.enableCore(null)) {
            return;
        }
        this.core_enabled = true;
        VersionCheck.runCheck(this.core);
        this.perTickLimit = this.core.getMaxTickUseMS() * 1000000;
        this.lasttick = System.nanoTime();
        this.tps = 20.0;
        if (!this.tickregistered) {
            ServerTickEvents.END_SERVER_TICK.register(server -> this.fserver.tickEvent(server));
            this.tickregistered = true;
        }
        this.playerList = this.core.playerList;
        this.sscache = new GenericChunkCache(this.core.getSnapShotCacheSize(), this.core.useSoftRefInSnapShotCache());
        this.mapManager = this.core.getMapManager();
        this.loadWorlds();
        for (FabricWorld w : this.worlds.values()) {
            if (!this.core.processWorldLoad(w) || !w.isLoaded()) continue;
            this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
        }
        this.core.updateConfigHashcode();
        this.registerEvents();
        Log.info("Register events");
        Log.info("Enabled");
    }

    public void onDisable() {
        DynmapCommonAPIListener.apiTerminated();
        this.saveWorlds();
        this.fserver.clearTaskQueue();
        this.core.disableCore();
        this.core_enabled = false;
        if (this.sscache != null) {
            this.sscache.cleanup();
            this.sscache = null;
        }
        Log.info("Disabled");
    }

    public void handleCommand(class_2168 commandSource, String cmd, String[] args) throws CommandSyntaxException {
        class_3222 psender = null;
        if (commandSource.method_9228() instanceof class_3222) {
            psender = commandSource.method_9207();
        }
        FabricCommandSender dsender = psender != null ? new FabricPlayer(this, psender) : new FabricCommandSender(commandSource);
        this.core.processCommand(dsender, cmd, cmd, args);
    }

    private void registerPlayerLoginListener() {
        if (this.playerTracker == null) {
            this.playerTracker = new PlayerTracker();
            PlayerEvents.PLAYER_LOGGED_IN.register(player -> this.playerTracker.onPlayerLogin(player));
            PlayerEvents.PLAYER_LOGGED_OUT.register(player -> this.playerTracker.onPlayerLogout(player));
            PlayerEvents.PLAYER_CHANGED_DIMENSION.register(player -> this.playerTracker.onPlayerChangedDimension(player));
            PlayerEvents.PLAYER_RESPAWN.register(player -> this.playerTracker.onPlayerRespawn(player));
        }
    }

    private void registerEvents() {
        this.onblockchange = this.core.isTrigger("blockupdate");
        this.onchunkpopulate = this.core.isTrigger("chunkpopulate");
        this.onchunkgenerate = this.core.isTrigger("chunkgenerate");
        this.onblockchange_with_id = this.core.isTrigger("blockupdate-with-id");
        if (this.onblockchange_with_id) {
            this.onblockchange = true;
        }
        if (this.worldTracker == null) {
            this.worldTracker = new WorldTracker();
        }
        if (this.onchunkpopulate || this.onchunkgenerate) {
            CustomServerChunkEvents.CHUNK_GENERATE.register((world, chunk) -> this.worldTracker.handleChunkGenerate(world, chunk));
        }
        if (this.onblockchange) {
            BlockEvents.BLOCK_EVENT.register((world, pos) -> this.worldTracker.handleBlockEvent(world, pos));
        }
        ServerWorldEvents.LOAD.register((server, world) -> this.worldTracker.handleWorldLoad(server, world));
        ServerWorldEvents.UNLOAD.register((server, world) -> this.worldTracker.handleWorldUnload(server, world));
    }

    FabricWorld getWorldByName(String name) {
        return this.worlds.get(name);
    }

    FabricWorld getWorld(class_1937 w) {
        return this.getWorld(w, true);
    }

    private FabricWorld getWorld(class_1937 w, boolean add_if_not_found) {
        if (this.last_world == w) {
            return this.last_fworld;
        }
        String wname = FabricWorld.getWorldName(this, w);
        for (FabricWorld fw : this.worlds.values()) {
            if (!fw.getRawName().equals(wname)) continue;
            this.last_world = w;
            this.last_fworld = fw;
            if (!fw.isLoaded()) {
                fw.setWorldLoaded(w);
            }
            fw.updateWorld(w);
            return fw;
        }
        FabricWorld fw = null;
        if (add_if_not_found) {
            fw = new FabricWorld(this, w);
            this.worlds.put(fw.getName(), fw);
        }
        this.last_world = w;
        this.last_fworld = fw;
        return fw;
    }

    private void saveWorlds() {
        File f = new File(this.core.getDataFolder(), "fabricworlds.yml");
        ConfigurationNode cn = new ConfigurationNode(f);
        ArrayList lst = new ArrayList();
        for (DynmapWorld fw : this.core.mapManager.getWorlds()) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("name", fw.getRawName());
            vals.put("height", fw.worldheight);
            vals.put("miny", fw.minY);
            vals.put("sealevel", fw.sealevel);
            vals.put("nether", fw.isNether());
            vals.put("the_end", ((FabricWorld)fw).isTheEnd());
            vals.put("title", fw.getTitle());
            lst.add(vals);
        }
        cn.put("worlds", (Object)lst);
        cn.put("useSaveFolderAsName", (Object)this.useSaveFolder);
        cn.put("maxWorldHeight", (Object)FabricWorld.getMaxWorldHeight());
        cn.save();
    }

    private void loadWorlds() {
        List<Map<String, Object>> lst;
        File f = new File(this.core.getDataFolder(), "fabricworlds.yml");
        if (!f.canRead()) {
            this.useSaveFolder = true;
            return;
        }
        ConfigurationNode cn = new ConfigurationNode(f);
        cn.load();
        FabricWorld.setMaxWorldHeight(cn.getInteger("maxWorldHeight", 256));
        if (cn.containsKey("useSaveFolderAsName")) {
            this.useSaveFolder = cn.getBoolean("useSaveFolderAsName", this.useSaveFolder);
        }
        if ((lst = cn.getMapList("worlds")) == null) {
            Log.warning(String.format("Discarding bad %s", "fabricworlds.yml"));
            return;
        }
        for (Map<String, Object> world : lst) {
            try {
                String name = (String)world.get("name");
                int height = (Integer)world.get("height");
                Integer miny = (Integer)world.get("miny");
                int sealevel = (Integer)world.get("sealevel");
                boolean nether = (Boolean)world.get("nether");
                boolean theend = (Boolean)world.get("the_end");
                String title = (String)world.get("title");
                if (name == null) continue;
                FabricWorld fw = new FabricWorld(this, name, height, sealevel, nether, theend, title, miny != null ? miny : 0);
                fw.setWorldUnloaded();
                this.core.processWorldLoad(fw);
                this.worlds.put(fw.getName(), fw);
            }
            catch (Exception x) {
                Log.warning(String.format("Unable to load saved worlds from %s", "fabricworlds.yml"));
                return;
            }
        }
    }

    static {
        TRIGGER_DEFAULTS = new String[]{"blockupdate", "chunkpopulate", "chunkgenerate"};
        patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    }

    public class PlayerTracker {
        public void onPlayerLogin(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricPlayer dp = DynmapPlugin.this.getOrAddPlayer(player);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_JOIN, dp);
                }
            }, 2L);
        }

        public void onPlayerLogout(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricPlayer dp = DynmapPlugin.this.getOrAddPlayer(player);
            final String name = player.method_5477().getString();
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_QUIT, dp);
                    DynmapPlugin.this.players.remove(name);
                }
            }, 0L);
        }

        public void onPlayerChangedDimension(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(player);
        }

        public void onPlayerRespawn(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(player);
        }
    }

    public class WorldTracker {
        public void handleWorldLoad(MinecraftServer server, class_3218 world) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    if (DynmapPlugin.this.core.processWorldLoad(fw)) {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, fw);
                    }
                }
            }, 0L);
        }

        public void handleWorldUnload(MinecraftServer server, class_3218 world) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world);
            if (fw != null) {
                DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                    @Override
                    public void run() {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_UNLOAD, fw);
                        DynmapPlugin.this.core.processWorldUnload(fw);
                    }
                }, 0L);
                fw.setWorldUnloaded();
            }
        }

        public void handleChunkGenerate(class_3218 world, class_2791 chunk) {
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world, false);
            class_1923 chunkPos = chunk.method_12004();
            int ymax = Integer.MIN_VALUE;
            int ymin = Integer.MAX_VALUE;
            class_2826[] sections = chunk.method_12006();
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i] == null || sections[i].method_38292()) continue;
                int sy = chunk.method_31607() + i * 16;
                if (sy < ymin) {
                    ymin = sy;
                }
                if (sy + 16 <= ymax) continue;
                ymax = sy + 16;
            }
            if (ymax != Integer.MIN_VALUE) {
                DynmapPlugin.this.mapManager.touchVolume(fw.getName(), chunkPos.method_8326(), ymin, chunkPos.method_8328(), chunkPos.method_8327(), ymax, chunkPos.method_8329(), "chunkgenerate");
            }
        }

        public void handleBlockEvent(class_1937 world, class_2338 pos) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            if (!DynmapPlugin.this.onblockchange) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            BlockUpdateRec r = new BlockUpdateRec();
            r.w = world;
            FabricWorld fw = DynmapPlugin.this.getWorld(world, false);
            if (fw == null) {
                return;
            }
            r.wid = fw.getName();
            r.x = pos.method_10263();
            r.y = pos.method_10264();
            r.z = pos.method_10260();
            DynmapPlugin.this.blockupdatequeue.add(r);
        }
    }

    public static class ChatHandler {
        private final DynmapPlugin plugin;

        ChatHandler(DynmapPlugin plugin) {
            this.plugin = plugin;
        }

        public void handleChat(class_3222 player, String message) {
            if (!message.startsWith("/")) {
                ChatMessage cm = new ChatMessage();
                cm.message = message;
                cm.sender = player;
                this.plugin.msgqueue.add(cm);
            }
        }
    }

    public class ProfileTexture {
        public String url;
    }

    public class TexturesPayload {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, ProfileTexture> textures;
    }

    static class ChatMessage {
        String message;
        class_3222 sender;

        ChatMessage() {
        }
    }

    public static class BlockUpdateRec {
        class_1936 w;
        String wid;
        int x;
        int y;
        int z;
    }
}

