/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class TopoHDShader
implements HDShader {
    private final String name;
    private final Color linecolor;
    private final Color[] fillcolor;
    private final Color watercolor;
    private BitSet hiddenids;
    private final int linespacing;
    private static final String[] nulllist = new String[0];

    public TopoHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        this.fillcolor = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.fillcolor[i] = configuration.getColor("color" + i, null);
        }
        this.linecolor = configuration.getColor("linecolor", null);
        this.watercolor = configuration.getColor("watercolor", null);
        float wateralpha = configuration.getFloat("wateralpha", 1.0f);
        if ((double)wateralpha < 1.0) {
            this.watercolor.setAlpha((int)(255.0f * wateralpha));
        }
        if (this.fillcolor[0] == null) {
            this.fillcolor[0] = new Color(0, 0, 0);
        }
        if (this.fillcolor[255] == null) {
            this.fillcolor[255] = new Color(255, 255, 255);
        }
        int starty = 0;
        for (int i = 1; i < 256; ++i) {
            if (this.fillcolor[i] == null) continue;
            int delta = i - starty;
            Color c0 = this.fillcolor[starty];
            Color c1 = this.fillcolor[i];
            for (int j = 1; j < delta; ++j) {
                this.fillcolor[starty + j] = new Color((c0.getRed() * (delta - j) + c1.getRed() * j) / delta, (c0.getGreen() * (delta - j) + c1.getGreen() * j) / delta, (c0.getBlue() * (delta - j) + c1.getBlue() * j) / delta);
            }
            starty = i;
        }
        this.hiddenids = new BitSet();
        this.setHidden(DynmapBlockState.AIR_BLOCK);
        List hidden = configuration.getList("hiddennames");
        if (hidden != null) {
            for (Object o : hidden) {
                if (!(o instanceof String)) continue;
                this.setHidden((String)o);
            }
        }
        this.linespacing = configuration.getInteger("linespacing", 1);
    }

    private void setHidden(String bn) {
        DynmapBlockState bs = DynmapBlockState.getBaseStateByName(bn);
        for (int i = 0; i < bs.getStateCount(); ++i) {
            DynmapBlockState b = bs.getState(i);
            this.hiddenids.set(b.globalStateIndex);
        }
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache, scale);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        throw new IOException("Export unsupported");
    }

    @Override
    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        return nulllist;
    }

    private class OurShaderState
    implements HDShaderState {
        private Color[] color;
        private Color[] tmpcolor;
        private Color c;
        protected MapIterator mapiter;
        protected HDMap map;
        private HDLighting lighting;
        private int scale;
        private int heightshift;
        private boolean inWater;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            this.mapiter = mapiter;
            this.map = map;
            this.lighting = map.getLighting();
            if (this.lighting.isNightAndDayEnabled()) {
                this.color = new Color[]{new Color(), new Color()};
                this.tmpcolor = new Color[]{new Color(), new Color()};
            } else {
                this.color = new Color[]{new Color()};
                this.tmpcolor = new Color[]{new Color()};
            }
            this.scale = scale;
            this.c = new Color();
            this.heightshift = 0;
            for (int wh = mapiter.getWorldHeight(); wh > 256; wh >>= 1) {
                ++this.heightshift;
            }
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
            this.inWater = false;
        }

        @Override
        public HDShader getShader() {
            return TopoHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
            this.inWater = false;
        }

        private final boolean isHidden(DynmapBlockState blk) {
            return TopoHDShader.this.hiddenids.get(blk.globalStateIndex);
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            int alpha2;
            DynmapBlockState blocktype = ps.getBlockState();
            if (this.isHidden(blocktype)) {
                return false;
            }
            int y = this.mapiter.getY();
            if (y < 0) {
                y = 0;
            }
            int[] xyz = ps.getSubblockCoord();
            Color lcolor = y % TopoHDShader.this.linespacing == 0 ? TopoHDShader.this.linecolor : null;
            switch (ps.getLastBlockStep()) {
                case Y_MINUS: 
                case Y_PLUS: {
                    if (lcolor != null && (xyz[0] == 0 && this.isHidden(this.mapiter.getBlockTypeAt(BlockStep.X_MINUS)) || xyz[0] == this.scale - 1 && this.isHidden(this.mapiter.getBlockTypeAt(BlockStep.X_PLUS)) || xyz[2] == 0 && this.isHidden(this.mapiter.getBlockTypeAt(BlockStep.Z_MINUS)) || xyz[2] == this.scale - 1 && this.isHidden(this.mapiter.getBlockTypeAt(BlockStep.Z_PLUS)))) {
                        this.c.setColor(lcolor);
                        this.inWater = false;
                        break;
                    }
                    if (TopoHDShader.this.watercolor != null && blocktype.isWater()) {
                        if (!this.inWater) {
                            this.c.setColor(TopoHDShader.this.watercolor);
                            this.inWater = true;
                            break;
                        }
                        return false;
                    }
                    this.c.setColor(TopoHDShader.this.fillcolor[y >> this.heightshift]);
                    this.inWater = false;
                    break;
                }
                default: {
                    if (lcolor != null && xyz[1] == this.scale - 1) {
                        this.c.setColor(lcolor);
                        this.inWater = false;
                        break;
                    }
                    if (TopoHDShader.this.watercolor != null && blocktype.isWater()) {
                        if (!this.inWater) {
                            this.c.setColor(TopoHDShader.this.watercolor);
                            this.inWater = true;
                            break;
                        }
                        return false;
                    }
                    this.c.setColor(TopoHDShader.this.fillcolor[y >> this.heightshift]);
                    this.inWater = false;
                }
            }
            this.lighting.applyLighting(ps, this, this.c, this.tmpcolor);
            if (this.color[0].isTransparent()) {
                for (int i = 0; i < this.color.length; ++i) {
                    this.color[i].setColor(this.tmpcolor[i]);
                }
                return this.color[0].getAlpha() == 255;
            }
            int alpha = this.color[0].getAlpha();
            int talpha = alpha + (alpha2 = this.tmpcolor[0].getAlpha() * (255 - alpha) / 255);
            if (talpha > 0) {
                for (int i = 0; i < this.color.length; ++i) {
                    this.color[i].setRGBA((this.tmpcolor[i].getRed() * alpha2 + this.color[i].getRed() * alpha) / talpha, (this.tmpcolor[i].getGreen() * alpha2 + this.color[i].getGreen() * alpha) / talpha, (this.tmpcolor[i].getBlue() * alpha2 + this.color[i].getBlue() * alpha) / talpha, talpha);
                }
            } else {
                for (int i = 0; i < this.color.length; ++i) {
                    this.color[i].setTransparent();
                }
            }
            return talpha >= 254;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }

        @Override
        public void setLastBlockState(DynmapBlockState new_lastbs) {
        }
    }
}

