/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.org.postgresql.xa;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.dynmap.org.postgresql.util.Base64;

class RecoveredXid
implements Xid {
    int formatId;
    byte[] globalTransactionId;
    byte[] branchQualifier;

    RecoveredXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        result = 31 * result + this.formatId;
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        if (other.getFormatId() != this.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public String toString() {
        return RecoveredXid.xidToString(this);
    }

    static String xidToString(Xid xid) {
        return xid.getFormatId() + "_" + Base64.encodeBytes(xid.getGlobalTransactionId(), 8) + "_" + Base64.encodeBytes(xid.getBranchQualifier(), 8);
    }

    static @Nullable Xid stringToXid(String s) {
        int b;
        int a = s.indexOf("_");
        if (a == (b = s.lastIndexOf("_"))) {
            return null;
        }
        try {
            int formatId = Integer.parseInt(s.substring(0, a));
            byte[] globalTransactionId = Base64.decode(s.substring(a + 1, b));
            byte[] branchQualifier = Base64.decode(s.substring(b + 1));
            return new RecoveredXid(formatId, globalTransactionId, branchQualifier);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

