/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.request;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PutObjectRequest {
    private final String acl;
    private final String bucketName;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final Long contentLength;
    private final String contentMD5;
    private final String contentType;
    private final Instant expires;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWrite;
    private final String grantWriteACP;
    private final String key;
    private final Map<String, String> metadata;
    private final String objectLockLegalHoldStatus;
    private final String objectLockMode;
    private final Instant objectLockRetainUntilDate;
    private final String requestPayer;
    private final String serverSideEncryption;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String sseEncryptionContext;
    private final String sseKmsKeyId;
    private final String storageClass;
    private final String tagging;
    private final String websiteRedirectLocation;

    private PutObjectRequest(Builder builder) {
        this.acl = builder.acl;
        this.bucketName = builder.bucketName;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.contentType = builder.contentType;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.objectLockLegalHoldStatus = builder.objectLockLegalHoldStatus;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
        this.requestPayer = builder.requestPayer;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.sseEncryptionContext = builder.sseEncryptionContext;
        this.sseKmsKeyId = builder.sseKmsKeyId;
        this.storageClass = builder.storageClass;
        this.tagging = builder.tagging;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Instant getExpires() {
        return this.expires;
    }

    public String getGrantFullControl() {
        return this.grantFullControl;
    }

    public String getGrantRead() {
        return this.grantRead;
    }

    public String getGrantReadACP() {
        return this.grantReadACP;
    }

    public String getGrantWrite() {
        return this.grantWrite;
    }

    public String getGrantWriteACP() {
        return this.grantWriteACP;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getObjectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public String getObjectLockMode() {
        return this.objectLockMode;
    }

    public Instant getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public String getRequestPayer() {
        return this.requestPayer;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getSseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String getSseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String getSseEncryptionContext() {
        return this.sseEncryptionContext;
    }

    public String getSseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getTagging() {
        return this.tagging;
    }

    public String getWebsiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PutObjectRequest that = (PutObjectRequest)obj;
        return Objects.equals(this.acl, that.acl) && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals(this.contentDisposition, that.contentDisposition) && Objects.equals(this.contentEncoding, that.contentEncoding) && Objects.equals(this.contentLanguage, that.contentLanguage) && Objects.equals(this.contentLength, that.contentLength) && Objects.equals(this.contentMD5, that.contentMD5) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.expires, that.expires) && Objects.equals(this.grantFullControl, that.grantFullControl) && Objects.equals(this.grantRead, that.grantRead) && Objects.equals(this.grantReadACP, that.grantReadACP) && Objects.equals(this.grantWrite, that.grantWrite) && Objects.equals(this.grantWriteACP, that.grantWriteACP) && Objects.equals(this.key, that.key) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.objectLockLegalHoldStatus, that.objectLockLegalHoldStatus) && Objects.equals(this.objectLockMode, that.objectLockMode) && Objects.equals(this.objectLockRetainUntilDate, that.objectLockRetainUntilDate) && Objects.equals(this.requestPayer, that.requestPayer) && Objects.equals(this.serverSideEncryption, that.serverSideEncryption) && Objects.equals(this.sseCustomerAlgorithm, that.sseCustomerAlgorithm) && Objects.equals(this.sseCustomerKey, that.sseCustomerKey) && Objects.equals(this.sseCustomerKeyMD5, that.sseCustomerKeyMD5) && Objects.equals(this.sseEncryptionContext, that.sseEncryptionContext) && Objects.equals(this.sseKmsKeyId, that.sseKmsKeyId) && Objects.equals(this.storageClass, that.storageClass) && Objects.equals(this.tagging, that.tagging) && Objects.equals(this.websiteRedirectLocation, that.websiteRedirectLocation);
    }

    public int hashCode() {
        return Objects.hash(this.acl, this.bucketName, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentLength, this.contentMD5, this.contentType, this.expires, this.grantFullControl, this.grantRead, this.grantReadACP, this.grantWrite, this.grantWriteACP, this.key, this.metadata, this.objectLockLegalHoldStatus, this.objectLockMode, this.objectLockRetainUntilDate, this.requestPayer, this.serverSideEncryption, this.sseCustomerAlgorithm, this.sseCustomerKey, this.sseCustomerKeyMD5, this.sseEncryptionContext, this.sseKmsKeyId, this.storageClass, this.tagging, this.websiteRedirectLocation);
    }

    public String toString() {
        return "PutObjectRequest{acl='" + this.acl + '\'' + ", bucketName='" + this.bucketName + '\'' + ", cacheControl='" + this.cacheControl + '\'' + ", contentDisposition='" + this.contentDisposition + '\'' + ", contentEncoding='" + this.contentEncoding + '\'' + ", contentLanguage='" + this.contentLanguage + '\'' + ", contentLength=" + this.contentLength + ", contentMD5='" + this.contentMD5 + '\'' + ", contentType='" + this.contentType + '\'' + ", expires=" + this.expires + ", grantFullControl='" + this.grantFullControl + '\'' + ", grantRead='" + this.grantRead + '\'' + ", grantReadACP='" + this.grantReadACP + '\'' + ", grantWrite='" + this.grantWrite + '\'' + ", grantWriteACP='" + this.grantWriteACP + '\'' + ", key='" + this.key + '\'' + ", metadata=" + this.metadata + ", objectLockLegalHoldStatus='" + this.objectLockLegalHoldStatus + '\'' + ", objectLockMode='" + this.objectLockMode + '\'' + ", objectLockRetainUntilDate=" + this.objectLockRetainUntilDate + ", requestPayer='" + this.requestPayer + '\'' + ", serverSideEncryption='" + this.serverSideEncryption + '\'' + ", sseCustomerAlgorithm='" + this.sseCustomerAlgorithm + '\'' + ", sseCustomerKey='" + this.sseCustomerKey + '\'' + ", sseCustomerKeyMD5='" + this.sseCustomerKeyMD5 + '\'' + ", sseEncryptionContext='" + this.sseEncryptionContext + '\'' + ", sseKmsKeyId='" + this.sseKmsKeyId + '\'' + ", storageClass='" + this.storageClass + '\'' + ", tagging='" + this.tagging + '\'' + ", websiteRedirectLocation='" + this.websiteRedirectLocation + '\'' + '}';
    }

    public static class Builder {
        private String acl;
        private String bucketName;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Long contentLength;
        private String contentMD5;
        private String contentType;
        private Instant expires;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWrite;
        private String grantWriteACP;
        private String key;
        private Map<String, String> metadata = new HashMap<String, String>();
        private String objectLockLegalHoldStatus;
        private String objectLockMode;
        private Instant objectLockRetainUntilDate;
        private String requestPayer;
        private String serverSideEncryption;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String sseEncryptionContext;
        private String sseKmsKeyId;
        private String storageClass;
        private String tagging;
        private String websiteRedirectLocation;

        private Builder() {
        }

        public Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder objectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        public Builder objectLockMode(String objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        public Builder objectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        public Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        public Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public Builder sseEncryptionContext(String sseEncryptionContext) {
            this.sseEncryptionContext = sseEncryptionContext;
            return this;
        }

        public Builder sseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = sseKmsKeyId;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        public Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }
    }
}

