/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.auth;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dynmap.s3lite.core.auth.SignableRequest;
import org.dynmap.s3lite.http.spi.HttpMethod;
import org.dynmap.s3lite.http.spi.request.RequestBody;

public class DefaultSignableRequest
implements SignableRequest {
    private final HttpMethod httpMethod;
    private final URI endpoint;
    private final String resourcePath;
    private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private RequestBody requestBody;

    public DefaultSignableRequest(HttpMethod httpMethod, URI endpoint, String resourcePath) {
        this.httpMethod = httpMethod;
        this.endpoint = endpoint;
        this.resourcePath = resourcePath;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public Optional<RequestBody> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    @Override
    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public void addParameter(String key, String value) {
        this.parameters.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, n -> new ArrayList()).add(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSignableRequest that = (DefaultSignableRequest)obj;
        return this.httpMethod == that.httpMethod && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.resourcePath, that.resourcePath) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.headers, that.headers) && Objects.equals(this.requestBody, that.requestBody);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.httpMethod, this.endpoint, this.resourcePath, this.parameters, this.headers, this.requestBody});
    }

    public String toString() {
        return "DefaultSignableRequest{httpMethod=" + (Object)((Object)this.httpMethod) + ", endpoint=" + this.endpoint + ", resourcePath='" + this.resourcePath + '\'' + ", parameters=" + this.parameters + ", headers=" + this.headers + ", requestBody=" + this.requestBody + '}';
    }
}

